% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_get_public_access_block}
\alias{s3control_get_public_access_block}
\title{Retrieves the PublicAccessBlock configuration for an AWS account}
\usage{
s3control_get_public_access_block(AccountId)
}
\arguments{
\item{AccountId}{[required] The account ID for the AWS account whose \code{PublicAccessBlock}
configuration you want to retrieve.}
}
\description{
Retrieves the \code{PublicAccessBlock} configuration for an AWS account. For
more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html}{Using Amazon S3 block public access}.

Related actions include:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html}{DeletePublicAccessBlock}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html}{PutPublicAccessBlock}
}
}
\section{Request syntax}{
\preformatted{svc$get_public_access_block(
  AccountId = "string"
)
}
}

\keyword{internal}
