% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_delete_file_system}
\alias{fsx_delete_file_system}
\title{Deletes a file system, deleting its contents}
\usage{
fsx_delete_file_system(FileSystemId, ClientRequestToken,
  WindowsConfiguration)
}
\arguments{
\item{FileSystemId}{[required] The ID of the file system you want to delete.}

\item{ClientRequestToken}{(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
ensure idempotent deletion. This is automatically filled on your behalf
when using the AWS CLI or SDK.}

\item{WindowsConfiguration}{}
}
\description{
Deletes a file system, deleting its contents. After deletion, the file
system no longer exists, and its data is gone. Any existing automatic
backups will also be deleted.
}
\details{
By default, when you delete an Amazon FSx for Windows File Server file
system, a final backup is created upon deletion. This final backup is
not subject to the file system's retention policy, and must be manually
deleted.

The \code{DeleteFileSystem} action returns while the file system has the
\code{DELETING} status. You can check the file system deletion status by
calling the DescribeFileSystems action, which returns a list of file
systems in your account. If you pass the file system ID for a deleted
file system, the DescribeFileSystems returns a \code{FileSystemNotFound}
error.

The data in a deleted file system is also deleted and can't be
recovered by any means.
}
\section{Request syntax}{
\preformatted{svc$delete_file_system(
  FileSystemId = "string",
  ClientRequestToken = "string",
  WindowsConfiguration = list(
    SkipFinalBackup = TRUE|FALSE,
    FinalBackupTags = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}

\examples{
# This operation deletes an Amazon FSx file system.
\donttest{svc$delete_file_system(
  FileSystemId = "fs-0498eed5fe91001ec"
)}

}
\keyword{internal}
