% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_list_multipart_uploads}
\alias{glacier_list_multipart_uploads}
\title{This operation lists in-progress multipart uploads for the specified
vault}
\usage{
glacier_list_multipart_uploads(accountId, vaultName, marker, limit)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
'\code{-}' (hyphen), in which case Amazon S3 Glacier uses the AWS account
ID associated with the credentials used to sign the request. If you use
an account ID, do not include any hyphens ('-') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{marker}{An opaque string used for pagination. This value specifies the upload at
which the listing of uploads should begin. Get the marker value from a
previous List Uploads response. You need only include the marker if you
are continuing the pagination of results started in a previous List
Uploads request.}

\item{limit}{Specifies the maximum number of uploads returned in the response body.
If this value is not specified, the List Uploads operation returns up to
50 uploads.}
}
\description{
This operation lists in-progress multipart uploads for the specified
vault. An in-progress multipart upload is a multipart upload that has
been initiated by an InitiateMultipartUpload request, but has not yet
been completed or aborted. The list returned in the List Multipart
Upload response has no guaranteed order.
}
\details{
The List Multipart Uploads operation supports pagination. By default,
this operation returns up to 50 multipart uploads in the response. You
should always check the response for a \code{marker} at which to continue the
list; if there are no more items the \code{marker} is \code{null}. To return a
list of multipart uploads that begins at a specific upload, set the
\code{marker} request parameter to the value you obtained from a previous
List Multipart Upload request. You can also limit the number of uploads
returned in the response by specifying the \code{limit} parameter in the
request.

Note the difference between this operation and listing parts
(ListParts). The List Multipart Uploads operation lists all multipart
uploads for a vault and does not require a multipart upload ID. The List
Parts operation requires a multipart upload ID since parts are
associated with a single upload.

An AWS account has full permission to perform all operations (actions).
However, AWS Identity and Access Management (IAM) users don't have any
permissions by default. You must grant them explicit permission to
perform specific actions. For more information, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html}{Access Control Using AWS Identity and Access Management (IAM)}.

For conceptual information and the underlying REST API, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html}{Working with Archives in Amazon S3 Glacier}
and \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html}{List Multipart Uploads}
in the \emph{Amazon Glacier Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_multipart_uploads(
  accountId = "string",
  vaultName = "string",
  marker = "string",
  limit = "string"
)
}
}

\examples{
# The example lists all the in-progress multipart uploads for the vault
# named examplevault.
\donttest{svc$list_multipart_uploads(
  accountId = "-",
  vaultName = "examplevault"
)}

}
\keyword{internal}
