% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_start_restore_job}
\alias{backup_start_restore_job}
\title{Recovers the saved resource identified by an Amazon Resource Name (ARN)}
\usage{
backup_start_restore_job(RecoveryPointArn, Metadata, IamRoleArn,
  IdempotencyToken, ResourceType)
}
\arguments{
\item{RecoveryPointArn}{[required] An ARN that uniquely identifies a recovery point; for example,
\verb{arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45}.}

\item{Metadata}{[required] A set of metadata key-value pairs. Lists the metadata that the recovery
point was created with.}

\item{IamRoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that AWS Backup uses to
create the target recovery point; for example,
\verb{arn:aws:iam::123456789012:role/S3Access}.}

\item{IdempotencyToken}{A customer chosen string that can be used to distinguish between calls
to \code{StartRestoreJob}. Idempotency tokens time out after one hour.
Therefore, if you call \code{StartRestoreJob} multiple times with the same
idempotency token within one hour, AWS Backup recognizes that you are
requesting only one restore job and initiates only one. If you change
the idempotency token for each call, AWS Backup recognizes that you are
requesting to start multiple restores.}

\item{ResourceType}{Starts a job to restore a recovery point for one of the following
resources:
\itemize{
\item \code{EBS} for Amazon Elastic Block Store
\item \code{SGW} for AWS Storage Gateway
\item \code{RDS} for Amazon Relational Database Service
\item \code{DDB} for Amazon DynamoDB
\item \code{EFS} for Amazon Elastic File System
}}
}
\description{
Recovers the saved resource identified by an Amazon Resource Name (ARN).
}
\details{
If the resource ARN is included in the request, then the last complete
backup of that resource is recovered. If the ARN of a recovery point is
supplied, then that recovery point is restored.
}
\section{Request syntax}{
\preformatted{svc$start_restore_job(
  RecoveryPointArn = "string",
  Metadata = list(
    "string"
  ),
  IamRoleArn = "string",
  IdempotencyToken = "string",
  ResourceType = "string"
)
}
}

\keyword{internal}
