% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_set_data_retrieval_policy}
\alias{glacier_set_data_retrieval_policy}
\title{This operation sets and then enacts a data retrieval policy in the
region specified in the PUT request}
\usage{
glacier_set_data_retrieval_policy(accountId, Policy)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID. This value must match the
AWS account ID associated with the credentials used to sign the request.
You can either specify an AWS account ID or optionally a single \'\code{-}\'
(hyphen), in which case Amazon Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you specify
your account ID, do not include any hyphens (\'-\') in the ID.}

\item{Policy}{The data retrieval policy in JSON format.}
}
\description{
This operation sets and then enacts a data retrieval policy in the
region specified in the PUT request. You can set one policy per region
for an AWS account. The policy is enacted within a few minutes of a
successful PUT operation.
}
\details{
The set policy operation does not affect retrieval jobs that were in
progress before the policy was enacted. For more information about data
retrieval policies, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html}{Amazon Glacier Data Retrieval Policies}.
}
\section{Request syntax}{
\preformatted{svc$set_data_retrieval_policy(
  accountId = "string",
  Policy = list(
    Rules = list(
      list(
        Strategy = "string",
        BytesPerHour = 123
      )
    )
  )
)
}
}

\examples{
# The example sets and then enacts a data retrieval policy.
\donttest{svc$set_data_retrieval_policy(
  Policy = list(
    Rules = list(
      list(
        BytesPerHour = 10737418240,
        Strategy = "BytesPerHour"
      )
    )
  ),
  accountId = "-"
)}

}
\keyword{internal}
