% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_snapshot_schedule}
\alias{storagegateway_describe_snapshot_schedule}
\title{Describes the snapshot schedule for the specified gateway volume}
\usage{
storagegateway_describe_snapshot_schedule(VolumeARN)
}
\arguments{
\item{VolumeARN}{[required] The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
operation to return a list of gateway volumes.}
}
\description{
Describes the snapshot schedule for the specified gateway volume. The
snapshot schedule information includes intervals at which snapshots are
automatically initiated on the volume. This operation is only supported
in the cached volume and stored volume types.
}
\section{Request syntax}{
\preformatted{svc$describe_snapshot_schedule(
  VolumeARN = "string"
)
}
}

\examples{
# Describes the snapshot schedule for the specified gateway volume
# including intervals at which snapshots are automatically initiated.
\donttest{svc$describe_snapshot_schedule(
  VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol..."
)}

}
\keyword{internal}
