% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_encryption}
\alias{s3_get_bucket_encryption}
\title{Returns the default encryption configuration for an Amazon S3 bucket}
\usage{
s3_get_bucket_encryption(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The name of the bucket from which the server-side encryption
configuration is retrieved.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Returns the default encryption configuration for an Amazon S3 bucket. If the bucket does not have a default encryption configuration, GetBucketEncryption returns \code{ServerSideEncryptionConfigurationNotFoundError}.

See \url{https://paws-r.github.io/docs/s3/get_bucket_encryption.html} for full documentation.
}
\keyword{internal}
