% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_metrics_configuration}
\alias{s3_get_bucket_metrics_configuration}
\title{Gets a metrics configuration (specified by the metrics configuration ID)
from the bucket}
\usage{
s3_get_bucket_metrics_configuration(Bucket, Id, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The name of the bucket containing the metrics configuration to retrieve.}

\item{Id}{[required] The ID used to identify the metrics configuration. The ID has a 64
character limit and can only contain letters, numbers, periods, dashes,
and underscores.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Gets a metrics configuration (specified by the metrics configuration ID) from the bucket. Note that this doesn't include the daily storage metrics.

See \url{https://www.paws-r-sdk.com/docs/s3_get_bucket_metrics_configuration/} for full documentation.
}
\keyword{internal}
