% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_create_snapshot}
\alias{storagegateway_create_snapshot}
\title{Initiates a snapshot of a volume}
\usage{
storagegateway_create_snapshot(VolumeARN, SnapshotDescription, Tags = NULL)
}
\arguments{
\item{VolumeARN}{[required] The Amazon Resource Name (ARN) of the volume. Use the
\code{\link[=storagegateway_list_volumes]{list_volumes}} operation to return a list
of gateway volumes.}

\item{SnapshotDescription}{[required] Textual description of the snapshot that appears in the Amazon EC2
console, Elastic Block Store snapshots panel in the \strong{Description}
field, and in the Storage Gateway snapshot \strong{Details} pane,
\strong{Description} field.}

\item{Tags}{A list of up to 50 tags that can be assigned to a snapshot. Each tag is
a key-value pair.

Valid characters for key and value are letters, spaces, and numbers
representable in UTF-8 format, and the following special characters: + -
= . _ : / @. The maximum length of a tag's key is 128 characters, and
the maximum length for a tag's value is 256.}
}
\description{
Initiates a snapshot of a volume.

See \url{https://www.paws-r-sdk.com/docs/storagegateway_create_snapshot/} for full documentation.
}
\keyword{internal}
