% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_complete_vault_lock}
\alias{glacier_complete_vault_lock}
\title{This operation completes the vault locking process by transitioning the
vault lock from the InProgress state to the Locked state, which causes
the vault lock policy to become unchangeable}
\usage{
glacier_complete_vault_lock(accountId, vaultName, lockId)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID. This value must match the
AWS account ID associated with the credentials used to sign the request.
You can either specify an AWS account ID or optionally a single '\code{-}'
(hyphen), in which case Amazon Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you specify
your account ID, do not include any hyphens ('-') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{lockId}{[required] The \code{lockId} value is the lock ID obtained from a
\code{\link[=glacier_initiate_vault_lock]{initiate_vault_lock}} request.}
}
\description{
This operation completes the vault locking process by transitioning the vault lock from the \code{InProgress} state to the \code{Locked} state, which causes the vault lock policy to become unchangeable. A vault lock is put into the \code{InProgress} state by calling \code{\link[=glacier_initiate_vault_lock]{initiate_vault_lock}}. You can obtain the state of the vault lock by calling \code{\link[=glacier_get_vault_lock]{get_vault_lock}}. For more information about the vault locking process, \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html}{Amazon Glacier Vault Lock}.

See \url{https://www.paws-r-sdk.com/docs/glacier_complete_vault_lock/} for full documentation.
}
\keyword{internal}
