% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{finspace}
\alias{finspace}
\title{FinSpace User Environment Management service}
\usage{
finspace(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
The FinSpace management service provides the APIs for managing FinSpace
environments.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- finspace(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.management:finspace_create_environment]{create_environment} \tab Create a new FinSpace environment\cr
\link[paws.management:finspace_create_kx_changeset]{create_kx_changeset} \tab Creates a changeset for a kdb database\cr
\link[paws.management:finspace_create_kx_cluster]{create_kx_cluster} \tab Creates a new kdb cluster\cr
\link[paws.management:finspace_create_kx_database]{create_kx_database} \tab Creates a new kdb database in the environment\cr
\link[paws.management:finspace_create_kx_environment]{create_kx_environment} \tab Creates a managed kdb environment for the account\cr
\link[paws.management:finspace_create_kx_user]{create_kx_user} \tab Creates a user in FinSpace kdb environment with an associated IAM role\cr
\link[paws.management:finspace_delete_environment]{delete_environment} \tab Delete an FinSpace environment\cr
\link[paws.management:finspace_delete_kx_cluster]{delete_kx_cluster} \tab Deletes a kdb cluster\cr
\link[paws.management:finspace_delete_kx_database]{delete_kx_database} \tab Deletes the specified database and all of its associated data\cr
\link[paws.management:finspace_delete_kx_environment]{delete_kx_environment} \tab Deletes the kdb environment\cr
\link[paws.management:finspace_delete_kx_user]{delete_kx_user} \tab Deletes a user in the specified kdb environment\cr
\link[paws.management:finspace_get_environment]{get_environment} \tab Returns the FinSpace environment object\cr
\link[paws.management:finspace_get_kx_changeset]{get_kx_changeset} \tab Returns information about a kdb changeset\cr
\link[paws.management:finspace_get_kx_cluster]{get_kx_cluster} \tab Retrieves information about a kdb cluster\cr
\link[paws.management:finspace_get_kx_connection_string]{get_kx_connection_string} \tab Retrieves a connection string for a user to connect to a kdb cluster\cr
\link[paws.management:finspace_get_kx_database]{get_kx_database} \tab Returns database information for the specified environment ID\cr
\link[paws.management:finspace_get_kx_environment]{get_kx_environment} \tab Retrieves all the information for the specified kdb environment\cr
\link[paws.management:finspace_get_kx_user]{get_kx_user} \tab Retrieves information about the specified kdb user\cr
\link[paws.management:finspace_list_environments]{list_environments} \tab A list of all of your FinSpace environments\cr
\link[paws.management:finspace_list_kx_changesets]{list_kx_changesets} \tab Returns a list of all the changesets for a database\cr
\link[paws.management:finspace_list_kx_cluster_nodes]{list_kx_cluster_nodes} \tab Lists all the nodes in a kdb cluster\cr
\link[paws.management:finspace_list_kx_clusters]{list_kx_clusters} \tab Returns a list of clusters\cr
\link[paws.management:finspace_list_kx_databases]{list_kx_databases} \tab Returns a list of all the databases in the kdb environment\cr
\link[paws.management:finspace_list_kx_environments]{list_kx_environments} \tab Returns a list of kdb environments created in an account\cr
\link[paws.management:finspace_list_kx_users]{list_kx_users} \tab Lists all the users in a kdb environment\cr
\link[paws.management:finspace_list_tags_for_resource]{list_tags_for_resource} \tab A list of all tags for a resource\cr
\link[paws.management:finspace_tag_resource]{tag_resource} \tab Adds metadata tags to a FinSpace resource\cr
\link[paws.management:finspace_untag_resource]{untag_resource} \tab Removes metadata tags from a FinSpace resource\cr
\link[paws.management:finspace_update_environment]{update_environment} \tab Update your FinSpace environment\cr
\link[paws.management:finspace_update_kx_cluster_databases]{update_kx_cluster_databases} \tab Updates the databases mounted on a kdb cluster, which includes the changesetId and all the dbPaths to be cached\cr
\link[paws.management:finspace_update_kx_database]{update_kx_database} \tab Updates information for the given kdb database\cr
\link[paws.management:finspace_update_kx_environment]{update_kx_environment} \tab Updates information for the given kdb environment\cr
\link[paws.management:finspace_update_kx_environment_network]{update_kx_environment_network} \tab Updates environment network to connect to your internal network by using a transit gateway\cr
\link[paws.management:finspace_update_kx_user]{update_kx_user} \tab Updates the user details
}
}

\examples{
\dontrun{
svc <- finspace()
svc$create_environment(
  Foo = 123
)
}

}
