% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{opsworkscm}
\alias{opsworkscm}
\title{AWS OpsWorks CM}
\usage{
opsworkscm(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
AWS OpsWorks for configuration management (CM) is a service that runs
and manages configuration management servers. You can use AWS OpsWorks
CM to create and manage AWS OpsWorks for Chef Automate and AWS OpsWorks
for Puppet Enterprise servers, and add or remove nodes for the servers
to manage.

\strong{Glossary of terms}
\itemize{
\item \strong{Server}: A configuration management server that can be
highly-available. The configuration management server runs on an
Amazon Elastic Compute Cloud (EC2) instance, and may use various
other AWS services, such as Amazon Relational Database Service (RDS)
and Elastic Load Balancing. A server is a generic abstraction over
the configuration manager that you want to use, much like Amazon
RDS. In AWS OpsWorks CM, you do not start or stop servers. After you
create servers, they continue to run until they are deleted.
\item \strong{Engine}: The engine is the specific configuration manager that
you want to use. Valid values in this release include \code{ChefAutomate}
and \code{Puppet}.
\item \strong{Backup}: This is an application-level backup of the data that the
configuration manager stores. AWS OpsWorks CM creates an S3 bucket
for backups when you launch the first server. A backup maintains a
snapshot of a server's configuration-related attributes at the time
the backup starts.
\item \strong{Events}: Events are always related to a server. Events are
written during server creation, when health checks run, when backups
are created, when system maintenance is performed, etc. When you
delete a server, the server's events are also deleted.
\item \strong{Account attributes}: Every account has attributes that are
assigned in the AWS OpsWorks CM database. These attributes store
information about configuration limits (servers, backups, etc.) and
your customer account.
}

\strong{Endpoints}

AWS OpsWorks CM supports the following endpoints, all HTTPS. You must
connect to one of the following endpoints. Your servers can only be
accessed or managed within the endpoint in which they are created.
\itemize{
\item opsworks-cm.us-east-1.amazonaws.com
\item opsworks-cm.us-east-2.amazonaws.com
\item opsworks-cm.us-west-1.amazonaws.com
\item opsworks-cm.us-west-2.amazonaws.com
\item opsworks-cm.ap-northeast-1.amazonaws.com
\item opsworks-cm.ap-southeast-1.amazonaws.com
\item opsworks-cm.ap-southeast-2.amazonaws.com
\item opsworks-cm.eu-central-1.amazonaws.com
\item opsworks-cm.eu-west-1.amazonaws.com
}

For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/opsworks-service.html}{AWS OpsWorks endpoints and quotas}
in the AWS General Reference.

\strong{Throttling limits}

All API operations allow for five requests per second with a burst of 10
requests per second.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- opsworkscm(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.management:opsworkscm_associate_node]{associate_node} \tab Associates a new node with the server\cr
\link[paws.management:opsworkscm_create_backup]{create_backup} \tab Creates an application-level backup of a server\cr
\link[paws.management:opsworkscm_create_server]{create_server} \tab Creates and immedately starts a new server\cr
\link[paws.management:opsworkscm_delete_backup]{delete_backup} \tab Deletes a backup\cr
\link[paws.management:opsworkscm_delete_server]{delete_server} \tab Deletes the server and the underlying AWS CloudFormation stacks (including the server's EC2 instance)\cr
\link[paws.management:opsworkscm_describe_account_attributes]{describe_account_attributes} \tab Describes your OpsWorks-CM account attributes\cr
\link[paws.management:opsworkscm_describe_backups]{describe_backups} \tab Describes backups\cr
\link[paws.management:opsworkscm_describe_events]{describe_events} \tab Describes events for a specified server\cr
\link[paws.management:opsworkscm_describe_node_association_status]{describe_node_association_status} \tab Returns the current status of an existing association or disassociation request\cr
\link[paws.management:opsworkscm_describe_servers]{describe_servers} \tab Lists all configuration management servers that are identified with your account\cr
\link[paws.management:opsworkscm_disassociate_node]{disassociate_node} \tab Disassociates a node from an AWS OpsWorks CM server, and removes the node from the server's managed nodes\cr
\link[paws.management:opsworkscm_export_server_engine_attribute]{export_server_engine_attribute} \tab Exports a specified server engine attribute as a base64-encoded string\cr
\link[paws.management:opsworkscm_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of tags that are applied to the specified AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise servers or backups\cr
\link[paws.management:opsworkscm_restore_server]{restore_server} \tab Restores a backup to a server that is in a CONNECTION_LOST, HEALTHY, RUNNING, UNHEALTHY, or TERMINATED state\cr
\link[paws.management:opsworkscm_start_maintenance]{start_maintenance} \tab Manually starts server maintenance\cr
\link[paws.management:opsworkscm_tag_resource]{tag_resource} \tab Applies tags to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server, or to server backups\cr
\link[paws.management:opsworkscm_untag_resource]{untag_resource} \tab Removes specified tags from an AWS OpsWorks-CM server or backup\cr
\link[paws.management:opsworkscm_update_server]{update_server} \tab Updates settings for a server\cr
\link[paws.management:opsworkscm_update_server_engine_attributes]{update_server_engine_attributes} \tab Updates engine-specific attributes on a specified server
}
}

\examples{
\dontrun{
svc <- opsworkscm()
svc$associate_node(
  Foo = 123
)
}

}
