% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{translate}
\alias{translate}
\title{Amazon Translate}
\usage{
translate(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Provides translation of the input content from the source language to
the target language.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- translate(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.machine.learning:translate_create_parallel_data]{create_parallel_data} \tab Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3\cr
\link[paws.machine.learning:translate_delete_parallel_data]{delete_parallel_data} \tab Deletes a parallel data resource in Amazon Translate\cr
\link[paws.machine.learning:translate_delete_terminology]{delete_terminology} \tab A synchronous action that deletes a custom terminology\cr
\link[paws.machine.learning:translate_describe_text_translation_job]{describe_text_translation_job} \tab Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on\cr
\link[paws.machine.learning:translate_get_parallel_data]{get_parallel_data} \tab Provides information about a parallel data resource\cr
\link[paws.machine.learning:translate_get_terminology]{get_terminology} \tab Retrieves a custom terminology\cr
\link[paws.machine.learning:translate_import_terminology]{import_terminology} \tab Creates or updates a custom terminology, depending on whether one already exists for the given terminology name\cr
\link[paws.machine.learning:translate_list_languages]{list_languages} \tab Provides a list of languages (RFC-5646 codes and names) that Amazon Translate supports\cr
\link[paws.machine.learning:translate_list_parallel_data]{list_parallel_data} \tab Provides a list of your parallel data resources in Amazon Translate\cr
\link[paws.machine.learning:translate_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags associated with a given Amazon Translate resource\cr
\link[paws.machine.learning:translate_list_terminologies]{list_terminologies} \tab Provides a list of custom terminologies associated with your account\cr
\link[paws.machine.learning:translate_list_text_translation_jobs]{list_text_translation_jobs} \tab Gets a list of the batch translation jobs that you have submitted\cr
\link[paws.machine.learning:translate_start_text_translation_job]{start_text_translation_job} \tab Starts an asynchronous batch translation job\cr
\link[paws.machine.learning:translate_stop_text_translation_job]{stop_text_translation_job} \tab Stops an asynchronous batch translation job that is in progress\cr
\link[paws.machine.learning:translate_tag_resource]{tag_resource} \tab Associates a specific tag with a resource\cr
\link[paws.machine.learning:translate_translate_document]{translate_document} \tab Translates the input document from the source language to the target language\cr
\link[paws.machine.learning:translate_translate_text]{translate_text} \tab Translates input text from the source language to the target language\cr
\link[paws.machine.learning:translate_untag_resource]{untag_resource} \tab Removes a specific tag associated with an Amazon Translate resource\cr
\link[paws.machine.learning:translate_update_parallel_data]{update_parallel_data} \tab Updates a previously created parallel data resource by importing a new input file from Amazon S3
}
}

\examples{
\dontrun{
svc <- translate()
svc$create_parallel_data(
  Foo = 123
)
}

}
