//WCC: wrapers for "scalapack_utility_fort.f".

#include <R.h>
#include <Rinternals.h>
#include "base_global.h"

SEXP R_PDLAPRNT(SEXP M, SEXP N, SEXP A, SEXP IA, SEXP JA, SEXP DESCA,
		SEXP IRPRNT, SEXP ICPRNT, SEXP CMATNM, SEXP NOUT, SEXP ICTXT,
		SEXP MYROW, SEXP MYCOL){
	F77_CALL(rpdlaprnt)(INTEGER(M), INTEGER(N), REAL(A), INTEGER(IA),
			INTEGER(JA), INTEGER(DESCA), INTEGER(IRPRNT),
			INTEGER(ICPRNT), CHARPT(CMATNM, 0), INTEGER(NOUT),
			INTEGER(ICTXT), INTEGER(MYROW), INTEGER(MYCOL));
			return(R_NilValue);
} /* End of R_PDLAPRNT(). */

SEXP R_PDGEMR2D(SEXP M, SEXP N, SEXP X, SEXP DESCX, SEXP CLDIM, SEXP DESCB,
		SEXP CTXT, SEXP LOCRX, SEXP LOCCX){
	SEXP B;

	PROTECT(B = allocMatrix(REALSXP, INTEGER(CLDIM)[0], INTEGER(CLDIM)[1]));
	
	Cpdgemr2d(INTEGER(M)[0], INTEGER(N)[0],
	  REAL(X), 1, 1, INTEGER(DESCX),
	  REAL(B), 1, 1, INTEGER(DESCB), INTEGER(CTXT)[0]);

/*	F77_CALL(rpdgemr2d)(INTEGER(M), INTEGER(N), REAL(X), INTEGER(DESCX),*/
/*			REAL(B), INTEGER(DESCB), INTEGER(CTXT),*/
/*			INTEGER(LOCRX), INTEGER(LOCCX),*/
/*			INTEGER(CLDIM)[0], INTEGER(CLDIM)[1]);*/

	UNPROTECT(1);
	return(B);
} /* End of R_PDGEMR2D(). */

