% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_special.r
\name{Hilbert}
\alias{Hilbert}
\title{Generate Hilbert Matrices}
\usage{
Hilbert(n, type = "matrix", ..., bldim = .pbd_env$BLDIM,
  ICTXT = .pbd_env$ICTXT)
}
\arguments{
\item{n}{number of rows and columns.}

\item{type}{"matrix" or "ddmatrix".}

\item{...}{Additional arguments.}

\item{bldim}{blocking dimension.}

\item{ICTXT}{BLACS context number.}
}
\value{
Returns a matrix or a distributed matrix.
}
\description{
Methods for constructing Hilbert matrices: H[i,j] = 1/(i+j-1)
}
\details{
This constructs the square Hilbert matrix of order \code{n}. The return is
either a matrix or a distributed matrix depending on the argument
\code{type=}.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

dx <- Hilbert(100, type="ddmatrix")

print(dx)

finalize()
}

}
\keyword{Data}
\keyword{Generation}

