% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generateCovItems}
\alias{generateCovItems}
\title{Generate paired comparison data with random correlations between items}
\usage{
generateCovItems(df, numItems, th = 0.5, name, ..., scale = 1, alpha = 1)
}
\arguments{
\item{df}{a data frame with pairs of vertices given in columns \code{pa1} and \code{pa2}, and item response data in other columns}

\item{numItems}{how many items to create}

\item{th}{a vector of thresholds}

\item{name}{a vector of item names}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{scale}{a vector of scaling constants}

\item{alpha}{a vector of item discriminations}
}
\value{
The given data.frame \code{df} with additional columns for each item.
In addition, you can obtain the correlation matrix used
to generate the latent worths from \code{attr(df, "cor")} and
and latent worths from \code{attr(df, "worth")}.
}
\description{
If you need access to the correlation matrix used to generate the
absolute latent scores then you will need to generate them yourself.
This is not difficult. See how in the example.
}
\section{Response model}{


See \link{cmp_probs} for details.
}

\examples{
library(mvtnorm)
df <- twoLevelGraph(letters[1:10], 100)
df <- generateCovItems(df, 3)

# generateCovItems essentially does the same thing as:
numItems <- 3
palist <- letters[1:10]
trueCor <- cov2cor(rWishart(1, numItems, diag(numItems))[,,1])
theta <- rmvnorm(length(palist), sigma=trueCor)
dimnames(theta) <- list(palist, paste0('i', 3 + 1:numItems))
df <- generateItem(df, theta)
attr(df, "cor")

}
\seealso{
Other item generators: 
\code{\link{generateFactorItems}()},
\code{\link{generateItem}()},
\code{\link{generateSingleFactorItems}()}
}
\concept{item generators}
