% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{prepFactorModel}
\alias{prepFactorModel}
\title{Specify a factor model}
\usage{
prepFactorModel(
  data,
  path,
  factorScalePrior = deprecated(),
  psiScalePrior = deprecated()
)
}
\arguments{
\item{data}{a data list prepared for processing by Stan}

\item{path}{a named list of item names}

\item{factorScalePrior}{a named numeric vector (deprecated)}

\item{psiScalePrior}{matrix of priors for factor correlations (deprecated)}
}
\value{
a data list suitable for passing as the \code{data}
  argument to \code{\link{pcStan}} or \code{\link[rstan]{stan}}
}
\description{
Specify a factor model with an arbitrary number of factors and
arbitrary factor-to-item structure.
}
\details{
For each factor, you need to specify its name and which items it predicts.
The connections from factors to items is specified by the `path` argument.
Both factors and items are specified by name (not index).
}
\examples{
pa <- phyActFlowPropensity[,setdiff(colnames(phyActFlowPropensity),
                                    c('goal1','feedback1'))]
dl <- prepData(pa)
dl <- prepFactorModel(dl,
                      list(flow=c('complex','skill','predict',
                                  'creative', 'novelty', 'stakes',
                                  'present', 'reward', 'chatter',
                                  'body'),
                           f2=c('waiting','control','evaluated','spont'),
                           rc=c('novelty', 'waiting')))
str(dl)
}
\seealso{
To simulate data from a factor model: \link{generateFactorItems}

Other factor model: 
\code{\link{prepSingleFactorModel}()}

Other data preppers: 
\code{\link{prepCleanData}()},
\code{\link{prepData}()},
\code{\link{prepSingleFactorModel}()}
}
\concept{data preppers}
\concept{factor model}
