% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DRM.R, R/print.DRM.R, R/summary.DRM.R
\name{DRM}
\alias{DRM}
\alias{print.DRM}
\alias{summary.DRM}
\title{Estimation of dichotomous logistic Rasch model (Rasch, 1960)}
\usage{
DRM(data, desmat, start, control)

\method{print}{DRM}(x, ...)

\method{summary}{DRM}(object, ...)
}
\arguments{
\item{data}{Data matrix or data frame; rows represent observations
(persons), columns represent the items.}

\item{desmat}{Design matrix; if missing, the design matrix for a dichotomous Rasch model will be created automatically.}

\item{start}{starting values for parameter estimation. If missing, a vector of 0 is used as starting values.}

\item{control}{list with control parameters for the estimation process e.g. the convergence criterion. For details please see the help pages to the R built-in function \code{optim}}

\item{x}{object of class \code{DRM}}

\item{object}{object of class \code{DRM}}

\item{\dots}{\dots{}}
}
\value{
\item{data}{data matrix according to the input} \item{design}{design
matrix either according to the input or according to the automatically
generated matrix} \item{logLikelihood}{conditional log-likelihood}
\item{estpar}{estimated basic item parameters}
\item{estpar_se}{estimated standard errors for basic item
parameters} \item{itempar}{estimated item parameters}
\item{itempar_se}{estimated standard errors for item parameters}
\item{hessian}{Hessian matrix} \item{convergence}{convergence of solution
(see help files in \code{\link{optim}})} \item{fun_calls}{number of function
calls (see help files in \code{\link{optim}})}
}
\description{
This function estimates the dichotomous Rasch model by Rasch
(1960).
}
\details{
Parameters are estimated by CML.
}
\examples{
#estimate Rasch model parameters
data(reason)
res_drm <- DRM(reason.test[,1:11])

summary(res_drm)
}
\author{
Christine Hohensinn
}
\references{
Fischer, G. H. (1974). Einfuehrung in die Theorie psychologischer Tests
[Introduction to test theory]. Bern: Huber.

Rasch, G. (1960). Probabalistic models for some intelligence and attainment tests. Danmarks paedagogiske institut.
}
\keyword{continuous}
\keyword{model}
\keyword{rating}
\keyword{scale}

