% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdgeUG2D.R
\name{edgesPE}
\alias{edgesPE}
\title{The edges of the underlying or reflexivity graph of
the Proportional Edge Proximity Catch Digraph
(PE-PCD) for 2D data - multiple triangle case}
\usage{
edgesPE(Xp, Yp, r, M = c(1, 1, 1), ugraph = c("underlying", "reflexivity"))
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying or reflexivity graph of the PE-PCD.}

\item{Yp}{A set of 2D points
which constitute the vertices of the Delaunay triangles.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 3D point in barycentric coordinates
which serves as a center in the interior of each Delaunay
triangle or circumcenter of each Delaunay triangle
(for this, argument should be set as \code{M="CC"}),
default for \eqn{M=(1,1,1)}
which is the center of mass of each triangle.}

\item{ugraph}{The type of the graph based on PE-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
A \code{list} with the elements
\item{type}{A description of the underlying
or reflexivity graph of the digraph}
\item{parameters}{Parameters of the underlying
or reflexivity graph of the digraph,
the center \code{M} used to
construct the vertex regions and the expansion parameter \code{r}.}
\item{tess.points}{Tessellation points, i.e., points on which the tessellation
of the study region is performed, here, tessellation
is Delaunay triangulation based on \code{Yp} points.}
\item{tess.name}{Name of the tessellation points \code{tess.points}}
\item{vertices}{Vertices of the underlying
or reflexivity graph of the digraph, \code{Xp} points}
\item{vert.name}{Name of the data set
which constitute the vertices of the underlying
or reflexivity graph of the digraph}
\item{LE, RE}{Left and right end points of the edges of
the underlying or reflexivity graph of PE-PCD for 2D data set \code{Xp}
as vertices of the underlying or reflexivity graph of the digraph}
\item{mtitle}{Text for \code{"main"} title
in the plot of the underlying or reflexivity graph of the digraph}
\item{quant}{Various quantities for the underlying or reflexivity graph of the digraph:
number of vertices, number of partition points,
number of intervals, number of edges, and edge density.}
}
\description{
An object of class \code{"UndPCDs"}.
Returns edges of the underlying or reflexivity graph of PE-PCD
as left and right end points
and related parameters and the quantities of these graphs.
The vertices of these graphs are the data points in \code{Xp}
in the multiple triangle case.

PE proximity regions are defined
with respect to the Delaunay triangles
based on \code{Yp} points with expansion parameter \eqn{r \ge 1} and
vertex regions in each triangle are
based on the center \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates
in the interior of each Delaunay triangle or
based on circumcenter of each Delaunay triangle
(default for \eqn{M=(1,1,1)}
which is the center of mass of the triangle).
The different consideration of circumcenter vs
any other interior center of the triangle is because
the projections from circumcenter are orthogonal to the edges,
while projections of \code{M} on the edges are on the extensions
of the lines connecting \code{M} and the vertices.
Each Delaunay triangle is first converted to
an (nonscaled) basic triangle so that \code{M} will be the same
type of center for each Delaunay triangle
(this conversion is not necessary when \code{M} is \eqn{CM}).

Convex hull of \code{Yp} is partitioned
by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles
whose union constitutes the
convex hull of \code{Yp} points).
For the number of edges, loops are not allowed so edges are only possible
for points inside the convex hull of \code{Yp} points.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph})
for more on the PE-PCDs.
Also, see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds.ugraph})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#\donttest{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-5;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))

M<-c(1,1,1)
r<-1.5

Edges<-edgesPE(Xp,Yp,r,M)
Edges
summary(Edges)
plot(Edges)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{edgesPEtri}}, \code{\link{edgesAS}}, \code{\link{edgesCS}},
and \code{\link[pcds]{arcsPE}}
}
\author{
Elvan Ceyhan
}
