% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{dp2pl}
\alias{dp2pl}
\title{The distance from a point to a plane}
\usage{
dp2pl(p, a, b, c)
}
\arguments{
\item{p}{A 3D point, distance from \code{p} to the plane passing through points \code{a}, \code{b},
and \code{c} are to be computed.}

\item{a, b, c}{3D points that determine the plane (i.e., through which the plane is passing).}
}
\value{
A \code{list} with two elements
\item{dis}{Distance from point \code{p} to the plane spanned by 3D points \code{a}, \code{b}, and \code{c}}
\item{cl2p}{The closest point on the plane spanned by 3D points \code{a}, \code{b}, and \code{c} to the point \code{p}}
}
\description{
Returns the distance from a point \code{p} to the plane passing through points \code{a}, \code{b}, and \code{c} in 3D space.
}
\examples{
\donttest{
A<-c(1,2,3); B<-c(3,9,12); C<-c(1,1,3); P<-c(5,2,40)

dis<-dp2pl(P,A,B,C);
dis
Pr<-dis$Pr2pl #projection on the plane

P2<-c(0,0,0)
dp2pl(P2,A,B,C);

dp2pl(A,A,B,C);

xseq<-seq(0,10,l=20)  #try also l=100
yseq<-seq(0,10,l=20)  #try also l=100

pl.grid<-Plane(A,B,C,xseq,yseq)$z

plot3D::persp3D(z = pl.grid, x = xseq, y = yseq, theta =225, phi = 30, ticktype = "detailed")
#plane spanned by points A, B, C
#add the vertices of the tetrahedron
plot3D::points3D(P[1],P[2],P[3], add=TRUE)
plot3D::points3D(Pr[1],Pr[2],Pr[3], add=TRUE)
plot3D::segments3D(P[1], P[2], P[3], Pr[1], Pr[2],Pr[3], add=TRUE,lwd=2)

plot3D::text3D(P[1]-.5,P[2],P[3]+1, c("P"),add=TRUE)
plot3D::text3D(Pr[1]-.5,Pr[2],Pr[3]+2, c("Pr"),add=TRUE)

persp(xseq,yseq,pl.grid, xlab="x",ylab="y",zlab="z",theta = -30,
phi = 30, expand = 0.5, col = "lightblue",
      ltheta = 120, shade = 0.05, ticktype = "detailed")

dp2pl(P,A,B,C)
}

}
\seealso{
\code{\link{dp2l}}, \code{\link{dist.pt2set}}  and \code{\link{Dist}}
}
\author{
Elvan Ceyhan
}
