% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternGen.R
\name{rascII.std.tri}
\alias{rascII.std.tri}
\title{Generation of points associated (in a Type II fashion) with the edges of \eqn{T_e}}
\usage{
rascII.std.tri(n, eps)
}
\arguments{
\item{n}{A positive integer representing the number of points to be generated.}

\item{eps}{A positive real number representing the parameter of type II association (where \eqn{\sqrt{3}/6}-\code{eps}
is the distance from the interior triangle distance from the interior triangle to \eqn{T_e}).}
}
\value{
A \code{list} with the elements
\item{type}{The type of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{parameters}{The attraction parameter, \code{eps}, of the association pattern, where \eqn{\sqrt{3}/6}-\code{eps}
is the distance from the interior triangle to \eqn{T_e}}
\item{ref.points}{The input set of points \code{Y};
reference points, i.e., points with which generated points are associated (i.e., vertices of \eqn{T_e}).}
\item{gen.points}{The output set of generated points associated with \code{Y} points (i.e., edges of \eqn{T_e}).}
\item{tri.Y}{Logical output for triangulation based on \code{Y} points should be implemented or not.
if \code{TRUE} triangulation based on \code{Y} points is to be implemented (default is set to \code{FALSE}).}
\item{desc.pat}{Description of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of generated points and
the number of reference (i.e., \code{Y}) points, which is 3 here.}
\item{xlimit,ylimit}{The ranges of the \eqn{x}- and \eqn{y}-coordinates of the reference points, which are the
vertices of \eqn{T_e} here}
}
\description{
An object of class \code{"Patterns"}.
Generates \code{n} points uniformly in the standard equilateral triangle \eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))}
under the type II association alternative for \code{eps} in \eqn{(0,\sqrt{3}/6=0.2886751]}.

In the type II association, the annular allowed regions around the edges are determined by
the parameter \code{eps} where \eqn{\sqrt{3}/6}-\code{eps} is the distance from the interior triangle
(i.e., forbidden region for association) to \eqn{T_e} (see examples for a sample plot.)
}
\examples{
\dontrun{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
n<-100  #try also n<-20 or n<-100 or 1000
eps<-.2  #try also .25, .1

set.seed(1)
Xdt<-rascII.std.tri(n,eps)
Xdt
summary(Xdt)
plot(Xdt,asp=1)

Xlim<-range(Te[,1])
Ylim<-range(Te[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

Xp<-Xdt$gen.points
plot(Te,pch=".",xlab="",ylab="",
main="Type II association in the \n standard equilateral triangle",
     xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01))
polygon(Te)
points(Xp)

#The support for the Type II association alternative
A1<-c(1/2-eps*sqrt(3),sqrt(3)/6-eps); B1<-c(1/2+eps*sqrt(3),sqrt(3)/6-eps);
C1<-c(1/2,sqrt(3)/6+2*eps);
supp<-rbind(A1,B1,C1)

plot(Te,asp=1,pch=".",xlab="",ylab="",main="Support of the Type II Association",
xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01))
polygon(Te,col=5)
polygon(supp,col=0)
points(Xp)
}

}
\seealso{
\code{\link{rseg.circ}}, \code{\link{rasc.circ}},  \code{\link{rsegII.std.tri}}, and \code{\link{rsegMT}}
}
\author{
Elvan Ceyhan
}
