% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{IncMatPE}
\alias{IncMatPE}
\title{Incidence matrix for Proportional Edge Proximity Catch Digraphs (PE-PCDs) - multiple triangle case}
\usage{
IncMatPE(Xp, Yp, r, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the PE-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 3D point in barycentric coordinates which serves as a center in the interior of each Delaunay
triangle or circumcenter of each Delaunay triangle (for this, argument should be set as \code{M="CC"}),
default for \eqn{M=(1,1,1)} which is the center of mass of each triangle.}
}
\value{
Incidence matrix for the PE-PCD with vertices being 2D data set, \code{Xp}.
PE proximity regions are constructed with respect to the Delaunay triangles and \code{M}-vertex regions.
}
\description{
Returns the incidence matrix of Proportional Edge Proximity Catch Digraph
(PE-PCD) whose vertices are the data points in \code{Xp} in the multiple triangle case.

PE proximity regions are
defined with respect to the Delaunay triangles based on \code{Yp} points with expansion parameter \eqn{r \ge 1} and
vertex regions in each triangle are based on the center \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of each Delaunay triangle or based on circumcenter of each Delaunay triangle
(default for \eqn{M=(1,1,1)} which is the center of mass of the triangle).

Each Delaunay triangle is first converted to an (nonscaled) basic triangle so that \code{M} will be the same
type of center for each Delaunay triangle (this conversion is not necessary when \code{M} is \eqn{CM}).

Convex hull of \code{Yp} is partitioned by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles whose union constitutes the
convex hull of \code{Yp} points). For the incidence matrix loops are allowed,
so the diagonal entries are all equal to 1.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-PE,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}) for more
on the PE-PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
\dontrun{
nx<-20; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

r<-1.5  #try also r<-2

IM<-IncMatPE(Xp,Yp,r,M)
IM
dom.greedy(IM)
#try also dom.exact(IM)  #might take a long time in this brute-force fashion ignoring the
#disconnected nature of the digraph inherent by the geometric construction of it
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IncMatPEtri}}, \code{\link{IncMatPETe}}, \code{\link{IncMatAS}}, and \code{\link{IncMatCS}}
}
\author{
Elvan Ceyhan
}
