% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxExtrema.R
\name{cl2CC.VRbas.tri}
\alias{cl2CC.VRbas.tri}
\title{The closest points to circumcenter in each \eqn{CC}-vertex region in a standard basic triangle}
\usage{
cl2CC.VRbas.tri(Xp, c1, c2, ch.all.intri = FALSE)
}
\arguments{
\item{Xp}{A set of 2D points representing the set of data points.}

\item{c1, c2}{Positive real numbers which constitute the vertex of the standard basic triangle.
adjacent to the shorter edges; \eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}}

\item{ch.all.intri}{A logical argument for checking whether all data points are inside \eqn{T_b}
(default is \code{FALSE}).}
}
\value{
A \code{list} with the elements
\item{txt1}{Vertex labels are \eqn{A=1}, \eqn{B=2}, and \eqn{C=3} (correspond to row number in Extremum Points).}
\item{txt2}{A short description of the distances as \code{"Distances from closest points to ..."}.}
\item{type}{Type of the extrema points}
\item{mtitle}{The \code{"main"} title for the plot of the extrema}
\item{ext}{The extrema points, here, closest points to \eqn{CC} in each vertex region.}
\item{X}{The input data, \code{Xp}, can be a \code{matrix} or \code{data frame}}
\item{num.points}{The number of data points, i.e., size of \code{Xp}}
\item{supp}{Support of the data points, here, it is \eqn{T_b}.}
\item{cent}{The center point used for construction of vertex regions}
\item{ncent}{Name of the center, \code{cent}, it is \code{"CC"} for this function.}
\item{regions}{Vertex regions inside the triangle, \eqn{T_b}, provided as a \code{list}.}
\item{region.names}{Names of the vertex regions as \code{"vr=1"}, \code{"vr=2"}, and \code{"vr=3"}}
\item{region.centers}{Centers of mass of the vertex regions inside \eqn{T_b}.}
\item{dist2ref}{Distances from closest points in each vertex region to CC.}
}
\description{
An object of class \code{"Extrema"}.
Returns the closest data points among the data set, \code{Xp}, to circumcenter, \eqn{CC}, in each \eqn{CC}-vertex region
in the standard basic triangle \eqn{T_b=T(A=(0,0),B=(1,0),C=(c_1,c_2))=}(vertex 1,vertex 2,vertex 3).
\code{ch.all.intri} is for checking whether all data points are inside \eqn{T_b} (default is \code{FALSE}).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C)
n<-15

set.seed(1)
Xp<-runif.bas.tri(n,c1,c2)$g

Ext<-cl2CC.VRbas.tri(Xp,c1,c2)
Ext
summary(Ext)
plot(Ext)

c2CC<-Ext

CC<-circ.cent.bas.tri(c1,c2)  #the circumcenter
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Tb[,1],Xp[,1])
Ylim<-range(Tb[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(A,pch=".",asp=1,xlab="",ylab="",
main="Closest Points in CC-Vertex Regions \n to the Circumcenter",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tb)
L<-matrix(rep(CC,3),ncol=2,byrow=TRUE); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(Xp)
points(c2CC$ext,pch=4,col=2)

txt<-rbind(Tb,CC,Ds)
xc<-txt[,1]+c(-.03,.03,.02,.07,.06,-.05,.01)
yc<-txt[,2]+c(.02,.02,.03,-.01,.03,.03,-.04)
txt.str<-c("A","B","C","CC","D1","D2","D3")
text(xc,yc,txt.str)

Xp2<-rbind(Xp,c(.2,.4))
cl2CC.VRbas.tri(Xp2,c1,c2,ch.all.intri = FALSE)
#gives an error message if ch.all.intri = TRUE
#since not all points are in the standard basic triangle
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cl2CC.VR}}, \code{\link{cl2edgesVRbas.tri}}, \code{\link{cl2edgesM_VR}}, \code{\link{cl2edgesCM_VR}}
and \code{\link{fr2edgesCM_ERstd.tri}}
}
\author{
Elvan Ceyhan
}
