% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFunctions.R
\name{summary.Planes}
\alias{summary.Planes}
\title{Return a summary of a \code{Planes} \code{object}}
\usage{
\method{summary}{Planes}(object, ...)
}
\arguments{
\item{object}{An \code{object} of class \code{Planes}.}

\item{\dots}{Additional parameters for \code{summary}.}
}
\value{
The \code{call} of the \code{object} of class \code{"Planes"},
the defining 3D \code{points}, selected \eqn{x}, \eqn{y}, and \eqn{z} points on the plane,
equation of the plane, and \code{coefficients} of the plane (in the form: \code{z = A*x + B*y + C}).
}
\description{
Returns the below information about the \code{object}:

\code{call} of the function defining the \code{object}, the defining 3D \code{points}, selected \eqn{x}, \eqn{y}, and \eqn{z} points on
the plane, equation of the plane, and \code{coefficients} of the plane.
}
\examples{
\dontrun{
P<-c(1,10,3); Q<-c(1,1,3); C<-c(3,9,12)
pts<-rbind(P,Q,C)

xr<-range(pts[,1]); yr<-range(pts[,2])
xf<-(xr[2]-xr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
yf<-(yr[2]-yr[1])*.1 #how far to go at the lower and upper ends in the y-coordinate
x<-seq(xr[1]-xf,xr[2]+xf,l=5) #try also l=10, 20 or 100
y<-seq(yr[1]-yf,yr[2]+yf,l=5) #try also l=10, 20 or 100

plPQC<-Plane(P,Q,C,x,y)
plPQC
summary(plPQC)
}

}
\seealso{
\code{\link{print.Planes}}, \code{\link{print.summary.Planes}}, and \code{\link{plot.Planes}}
}
