% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{IarcPEtri}
\alias{IarcPEtri}
\title{The indicator for the presence of an arc from a point to another
for Proportional Edge Proximity Catch Digraphs (PE-PCDs) -
one triangle case}
\usage{
IarcPEtri(p1, p2, tri, r, M = c(1, 1, 1), rv = NULL)
}
\arguments{
\item{p1}{A 2D point whose PE proximity region is constructed.}

\item{p2}{A 2D point.
The function determines whether \code{p2} is
inside the PE proximity region of
\code{p1} or not.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}
or the circumcenter of \code{tri}
which may be entered as "CC" as well;
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \code{tri}.}

\item{rv}{Index of the \code{M}-vertex region containing the point,
either \code{1,2,3} or \code{NULL}
(default is \code{NULL}).}
}
\value{
\eqn{I(}\code{p2} is in \eqn{N_{PE}(p1,r))}
for points \code{p1} and \code{p2},
that is, returns 1 if \code{p2} is in \eqn{N_{PE}(p1,r)},
and returns 0 otherwise.
}
\description{
Returns \eqn{I(}\code{p2} is in \eqn{N_{PE}(p1,r))}
for points \code{p1} and \code{p2},
that is, returns 1 if \code{p2} is in \eqn{N_{PE}(p1,r)},
and returns 0 otherwise,
where \eqn{N_{PE}(x,r)} is the PE proximity region for point \eqn{x}
with the expansion parameter \eqn{r \ge 1}.

PE proximity region is constructed
with respect to the triangle \code{tri} and
vertex regions are based on the center, \eqn{M=(m_1,m_2)}
in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of \code{tri}
or based on the circumcenter of \code{tri};
default is \eqn{M=(1,1,1)}, i.e.,
the center of mass of \code{tri}.
\code{rv} is the index of the vertex region \code{p1} resides,
with default=\code{NULL}.

If \code{p1} and \code{p2} are distinct
and either of them are outside \code{tri}, it returns 0,
but if they are identical,
then it returns 1 regardless of their locations
(i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-PE,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0);

r<-1.5

n<-3
set.seed(1)
Xp<-runif.tri(n,Tr)$g

IarcPEtri(Xp[1,],Xp[2,],Tr,r,M)

P1<-as.numeric(runif.tri(1,Tr)$g)
P2<-as.numeric(runif.tri(1,Tr)$g)
IarcPEtri(P1,P2,Tr,r,M)

P1<-c(.4,.2)
P2<-c(1.8,.5)
IarcPEtri(P1,P2,Tr,r,M)
IarcPEtri(P2,P1,Tr,r,M)

M<-c(1.3,1.3)
r<-2

#or try
Rv<-rel.vert.tri(P1,Tr,M)$rv
IarcPEtri(P1,P2,Tr,r,M,Rv)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IarcPEbasic.tri}}, \code{\link{IarcPEstd.tri}},
\code{\link{IarcAStri}}, and \code{\link{IarcCStri}}
}
\author{
Elvan Ceyhan
}
