% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{arcsPEint}
\alias{arcsPEint}
\title{The arcs of Proportional Edge Proximity Catch Digraph (PE-PCD) for 1D data - one interval case}
\usage{
arcsPEint(Xp, int, r, c = 0.5)
}
\arguments{
\item{Xp}{A set or \code{vector} of 1D points which constitute the vertices of the PE-PCD.}

\item{int}{A \code{vector} of two 1D points which constitutes the end points of the interval.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside middle intervals
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
A \code{list} with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph, here, they are expansion and centrality parameters.}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is the intervalization of the real line based on \code{int} points.}
\item{tess.name}{Name of data set used in tessellation, it is \code{int} for this function}
\item{vertices}{Vertices of the digraph, \code{Xp} points}
\item{vert.name}{Name of the data set which constitute the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of PE-PCD for 1D data}
\item{E}{Heads (or arrow ends) of the arcs of PE-PCD for 1D data}
\item{mtitle}{Text for \code{"main"} title in the plot of the digraph}
\item{quant}{Various quantities for the digraph: number of vertices, number of partition points,
number of intervals, number of arcs, and arc density.}
}
\description{
An object of class \code{"PCDs"}.
Returns arcs as tails (or sources) and heads (or arrow ends) for 1D data set \code{Xp} as the vertices
of PE-PCD.  \code{int} determines the end points of the interval.

For this function, PE proximity regions are constructed data points inside or outside the interval based
on \code{int} points with expansion parameter \eqn{r \ge 1} and centrality parameter \eqn{c \in (0,1)}. That is, for this function,
arcs may exist for points in the middle or end intervals.
It also provides various descriptions and quantities about the arcs of the PE-PCD
such as number of arcs, arc density, etc.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
\dontrun{
r<-2
c<-.4
a<-0; b<-10; int<-c(a,b);

#n is number of X points
n<-10; #try also n<-20

xf<-(int[2]-int[1])*.1

set.seed(1)
Xp<-runif(n,a-xf,b+xf)

Arcs<-arcsPEint(Xp,int,r,c)
Arcs
summary(Arcs)
plot(Arcs)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{arcsPE1D}}, \code{\link{arcsPEmid.int}}, \code{\link{arcsPEend.int}}, and \code{\link{arcsCS1D}}
}
\author{
Elvan Ceyhan
}
