% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFunctions.R
\name{plot.Extrema}
\alias{plot.Extrema}
\title{Plot an \code{Extrema} \code{object}}
\usage{
\method{plot}{Extrema}(x, asp = NA, xlab = "", ylab = "", zlab = "", ...)
}
\arguments{
\item{x}{Object of class \code{Extrema}.}

\item{asp}{A \code{numeric} value,
giving the aspect ratio for \eqn{y}-axis to \eqn{x}-axis
\eqn{y/x} for the 2D case,
it is redundant in the 3D case (default is \code{NA}),
see the official help for \code{asp} by typing "\code{? asp}".}

\item{xlab, ylab, zlab}{Titles
for the \eqn{x} and \eqn{y} axes in the 2D case,
and \eqn{x}, \eqn{y}, and \eqn{z} axes in the 3D case,
respectively (default is \code{""} for all).}

\item{\dots}{Additional parameters for \code{plot}.}
}
\value{
None
}
\description{
Plots the data points and extrema
among these points together with the reference object
(e.g., boundary of the support region)
}
\examples{
\dontrun{
n<-10
Xp<-runif.std.tri(n)$gen.points
Ext<-cl2edges.std.tri(Xp)
Ext
plot(Ext,asp=1)
}

}
\seealso{
\code{\link{print.Extrema}},
\code{\link{summary.Extrema}},
and \code{\link{print.summary.Extrema}}
}
