\name{create.tab}
\alias{create.tab}
\title{
Generate a summary table file for arm-based method
}
\description{
\code{create.tab} generates a concise table file from the summary result given by the function \code{\link{nma.ab}}, and the table demonstrates mutual relationships between different treatments. In the table file, diagonal elements are population-averaged event rates; upper and lower triangular elements show the risk ratio (RR), risk difference (RD), or odds ratio (OR) with the corresponding credible interval or standard error.
}
\usage{
create.tab(summary.stat, type = "CI", compare = 1, f.name = "", trtname,
           order = TRUE, o.path = getwd())
}
\arguments{
  \item{summary.stat}{
  a data frame read from the summary result file generated by the function \code{\link{nma.ab}}. We can use the function \code{\link[utils]{read.table}} to import the file.
}
  \item{type}{
  a charater string. It should be set as either \code{"CI"} (the default) or \code{"SE"}. If set as \code{"CI"}, credible interval would follow the estimated value in the generated table file; otherwise, estimated value would be followed by the corresponding standard error.
}
  \item{compare}{
  an integer chosen from \code{1} (the default), \code{2}, \code{3}, \code{4}, \code{5}, and \code{6}. \code{1} stands for upper triangular elements in the table being RR and lower being RD; \code{2} for upper RD and lower RR; \code{3} for upper RR and lower OR; \code{4} for upper OR and lower RR; \code{5} for upper RD and lower OR; \code{6} for upper OR and lower RD.
}
  \item{f.name}{
  a character string indicating the name of generated table file. The default is an empty character.
}
  \item{trtname}{
  a vector of character string indicating treatment names, and they would be used as the row and column names in the generated table. The default is "treat1", "treat2", and so on.
}
  \item{order}{
  logical. If \code{TRUE} (the default),  lower treatment ID is compared to higher treatment ID for effect sizes (e.g., RR, RD, and OR) in the off-diagonal elements in the generated table; otherwise, higher treatment ID is compared to lower one for corresponding effect size.
}
  \item{o.path}{
  output path. If not specified, it would be set as the working directory before runing this function.
}
}
\value{
A file containing a summary table for treatment comparisons, with diagonal elements being population-averaged event rates and off-diagonal elements being RRs, RDs, or ORs with their credible intervals or standard errors.
}
\references{
Zhang J, Carlin BP, Neaton JD, Soon GG, Nie L, Kane R, Virnig BA, Chu H (2014). "Network meta-analysis of randomized clinical trials: Reporting the proper summaries." \emph{Clin Trials} \bold{11}(2), 246--262.
}
\author{
Lifeng Lin, Jing Zhang, and Haitao Chu.
}


\examples{
## summary RR-RD table for network Middleton 2010
data(Middleton10)
attach(Middleton10)
set.seed(12345)
nma.ab(s.id = sid, t.id = tid, event.n = r, total.n = n,
       f.name = "Middleton10_", n.iter = 500, dic = FALSE)
detach(Middleton10)
create.tab(summary.stat = read.table("Middleton10_Summary.stat", header = TRUE),
           type = "CI", f.name = "Middleton10-")
}