\name{nma.networkplot}
\alias{nma.networkplot}
\title{
Network Plot of Treatment Comparisons
}
\description{
\code{nma.networkplot} plots a visual network presenting comparisons of treatments in various studies.
}
\usage{
nma.networkplot(s.id, t.id, title = "", trtname, alphabetic = TRUE,
                weight = TRUE, adjust.thick = 5, node.size = 3,
                node.col = "blue", edge.col = "black", text.cex = 1,
                adjust.figsizex = 1.1, adjust.figsizey = 1.1)
}
\arguments{
  \item{s.id}{
  a numeric or character vector indicating study ID.
}
  \item{t.id}{
  a numeric or character vector indicating treatment ID.
}
  \item{title}{
  a character string indicating plot title.
}
  \item{trtname}{
  a vector of character string indicating the treatment names for the corresponding treatment IDs according their order in \code{t.id}. If not specified, \code{t.id} is used as treatment names.
}
  \item{alphabetic}{
  a logical value indicating whether to sort the treatment alphabetically in the network plot. The default is \code{TRUE}.
}
  \item{weight}{
  a logical value indicating whether to draw the edges proportionally to the number of comparisons between the two treatments. The default is \code{TRUE}.
}
  \item{adjust.thick}{
  a positive integer indicating the maximum thickness of the edge when \code{weight} is \code{TRUE}. The default is 5.
}
  \item{node.size}{
  a positive integer indicating the sizes of treatment nodes. The default is 3.
}
  \item{node.col}{
  a character string indicating the color of treatment nodes. The default is \code{"blue"}.
}
  \item{edge.col}{
  a character string indicating the color of edges between treatments nodes. The default is \code{"black"}.
}
  \item{text.cex}{
  a positive integer indicating the sizes of treatment names written around the corresponding nodes. The default is 1.
}
  \item{adjust.figsizex}{
  a positive number used to adjust the plot width. The default is 1.1.
}
  \item{adjust.figsizey}{
  a positive number used to adjust the plot height. The default is 1.1.
}
}

\value{
A network plot is generated by this function. Each node in the plot represents a treatment, and the edges indicate the direct comparisons between the two treatments in various studies.
}

\examples{
data(smoke)
nma.networkplot(s.id = smoke$sid, t.id = smoke$tid, weight = TRUE,
  title = "Smoke Cessation Data", adjust.figsizex = 1.1,
  trtname = c("NC", "SH", "IC", "GC"))
# NC: No contact; SH: Self-help
# IC: individual counselling; GC: group counselling

data(diabetes)
nma.networkplot(s.id = diabetes$sid, t.id = diabetes$tid, weight = TRUE,
  title = "Diabetes Data", trtname = c("Diuretic", "Placebo",
  "b-blocker", "CCB", "ACE inhibitor", "ARB"))
}