% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{my_circle_packing}
\alias{my_circle_packing}
\title{My Circle packing plot}
\usage{
my_circle_packing(
  test,
  anno = NULL,
  mode = 1,
  Group = "level",
  Score = "weight",
  label = "label",
  show_level_name = "all",
  show_tip_label = TRUE,
  str_width = 10
)
}
\arguments{
\item{test}{a dataframe with hierarchical structure}

\item{anno}{annotation tablewith rowname for color or fill.}

\item{mode}{1~2}

\item{Group}{fill for mode2}

\item{Score}{color for mode1}

\item{label}{the labels column}

\item{show_level_name}{show which level name? a vector contains some column names.}

\item{show_tip_label}{show_tip_label, logical}

\item{str_width}{str_width}
}
\value{
ggplot
}
\description{
My Circle packing plot
}
\examples{
\donttest{
data(otutab)
cbind(taxonomy, weight = rowSums(otutab))[1:10, ] -> test
if (requireNamespace("igraph") && requireNamespace("ggraph")) {
  my_circle_packing(test)
}
}
}
