% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topPredictors.R
\name{topPredictors}
\alias{topPredictors}
\alias{topPredictors.default}
\alias{topPredictors.train}
\title{Extract Most "Important" Predictors (Experimental)}
\usage{
topPredictors(object, n = 1L, ...)

\method{topPredictors}{default}(object, n = 1L, ...)

\method{topPredictors}{train}(object, n = 1L, ...)
}
\arguments{
\item{object}{A fitted model object of appropriate class (e.g.,
\code{"gbm"}, \code{"lm"}, \code{"randomForest"}, etc.).}

\item{n}{Integer specifying the number of predictors to return. Default is
\code{1}] meaning return the single most important predictor.}

\item{...}{Additional optional arguments to be passed onto
\code{\link[caret]{varImp}}.}
}
\description{
Extract the most "important" predictors for regression and classification
models.
}
\details{
This function uses the generic function \code{\link[caret]{varImp}} to
calculate variable importance scores for each predictor. After that, they are
sorted at the names of the \code{n} highest scoring predictors are returned.
}
\examples{
\dontrun{

# Fit a random forest to the boston housing data
library(randomForest)
data (boston)  # load the boston housing data
set.seed(101)  # for reproducibility
boston.rf <- randomForest(cmedv ~ ., data = boston)

# What are the top four predictors?
topPredictors(boston.rf, n = 4)

# Construct PDPs for the top four predictors
par(mfrow = c(2, 2))
for (pred in topPredictors(boston.rf, 4)) {
  plot(partial(boston.rf, pred.var = pred), type = "l")
}

# Construct a two-way PDP for the top two predictors
boston.rf \%>\%
  partial(topPredictors(., n = 2), chull = TRUE) \%>\%
  plotPartial()

}
}
