% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_duplicates.R
\name{show_duplicates}
\alias{show_duplicates}
\title{Show Duplicate Observations in Your Dyad-Year or State-Year Data Frame}
\usage{
show_duplicates(data)
}
\arguments{
\item{data}{a dyad-year data frame or a state-year data frame created in \pkg{peacesciencer}.}
}
\value{
\code{show_duplicates()} takes a dyad-year data frame or state-year data frame generated in \pkg{peacesciencer} and
shows what observations are duplicated by unique combination of dyad-year or state-year, contingent on what was supplied to it.
}
\description{
\code{show_duplicates()} shows which data are duplicated in data generated in \pkg{peacesciencer}. It's a
useful diagnostic tool for users doing some do-it-yourself functions with \pkg{peacesciencer}.
}
\details{
The function leans on attributes of the data that are provided by the \code{create_dyadyear()} or
\code{create_stateyear()} function. Make sure that function (or data created by that function) appear at the top
of the proverbial pipe.

The data returned will also have a new column called \code{duplicated}. Thus, an implicit assumption in this function is the
user does not have a column in the data with this name that is of interest to the user. It will be overwritten.
}
\examples{

# just call `library(tidyverse)` at the top of the your script
library(magrittr)

gml_dirdisp \%>\% show_duplicates()
cow_mid_dirdisps \%>\% show_duplicates()
}
\author{
Steven V. Miller
}
