% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_atop_alliance.R
\name{add_atop_alliance}
\alias{add_atop_alliance}
\title{Add Alliance Treaty Obligations and Provisions (ATOP) alliance data to a dyad-year data frame}
\usage{
add_atop_alliance(data)
}
\arguments{
\item{data}{a data frame with appropriate \pkg{peacesciencer} attributes}
}
\value{
\code{add_atop_alliance()} takes a (dyad-year, leader-dyad-year) data frame and adds information about
the alliance pledge in that given dyad-year from the ATOP data. These include whether there was an alliance
with a defense pledge, an offense pledge, neutrality pledge, non-aggression pledge, or pledge for consultation
in time of crisis.
}
\description{
\code{add_atop_alliance()} allows you to add Alliance Treaty Obligations and Provisions (ATOP)
data to a (dyad-year, leader-dyad-year) data frame.
}
\details{
Data are from version 5.0 of ATOP.

This function will also work with leader-dyad-years, though users should be careful with leader-level
applications of alliance data. Alliance data are primarily communicated yearly, making it possible---even
likely---that at least one leader-dyad in a given year is credited with an alliance that was not active in the particular
leader-dyad. The ATOP alliance data are not communicated with time measurements more granular than
the year, at least for dyad-years. The alliance-level data provided by ATOP do have termination dates, but I am unaware
how well these start and termination dates coincide with particular members joining after the fact or exiting early. The alliance
phase data appear to communicate that "phases" are understood as beginning/ending when the underlying document is amended in such a
way that it affects one of their variable codings, but this may or may not be because of a signatory joining after the fact or exiting
early. More guidance will be useful going forward, but use these data for leader-level analyses with that in mind.
}
\examples{

# just call `library(tidyverse)` at the top of the your script
library(magrittr)

cow_ddy \%>\% add_atop_alliance()

}
\references{
Leeds, Brett Ashley, Jeffrey M. Ritter, Sara McLaughlin Mitchell, and Andrew G. Long. 2002.
Alliance Treaty Obligations and Provisions, 1815-1944. \emph{International Interactions} 28: 237-60.
}
\author{
Steven V. Miller
}
