% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_capital_distance.R
\name{add_capital_distance}
\alias{add_capital_distance}
\title{Add capital-to-capital distance to a data frame}
\usage{
add_capital_distance(data)
}
\arguments{
\item{data}{a data frame with appropriate \pkg{peacesciencer} attributes}
}
\value{
\code{add_capital_distance()} takes a (dyad-year, leader-year, leader-dyad-year, state-year) data frame and adds the
capital-to-capital distance between the first state and the second state (in dyad-year data) or the minimum
capital-to-capital distance for a given state in a given year. A minor
note about this function: cases of capital transition are recorded in the
underlying data but, in the conversion to capital-years (and eventual
merging into a dyad-year data frame), the Jan. 1 capital is used for calculating
distances.
}
\description{
\code{add_capital_distance()} allows you to add capital-to-capital
distance to a (dyad-year, leader-year, leader-dyad-year, state-year) data frame. The capitals are coded in the
\code{cow_capitals} and \code{gw_capitals}
data frames, along with their latitudes and longitudes. The distance variable that
emerges \code{capdist} is calculated using the "Vincenty" method (i.e. "as the crow
flies") and is expressed in kilometers.
}
\details{
The function leans on attributes of the data that are provided by one of the "create" functions
in this package (e.g. \code{create_dyadyear()} or \code{create_stateyear()}).
}
\examples{

\donttest{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)
cow_ddy \%>\% add_capital_distance()

create_stateyears() \%>\% add_capital_distance()
}


}
\author{
Steven V. Miller
}
