% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lumpedModel.R
\name{lumpedMatrix}
\alias{lumpedMatrix}
\alias{lumpedModel}
\title{Combine alleles in a mutation matrix}
\usage{
lumpedMatrix(mutmat, lump, afreq = attr(mutmat, "afreq"), check = TRUE)

lumpedModel(mutmod, lump, afreq = NULL, check = TRUE)
}
\arguments{
\item{mutmat}{A \code{mutationMatrix} object.}

\item{lump}{A nonempty subset of the column names of \code{mutmat} (i.e., the allele
labels).}

\item{afreq}{A vector with frequency vector, of the same length as the size
of \code{mutmat}. If not given, the \code{afreq} attribute of the matrix is used.}

\item{check}{A logical indicating if lumpability should be checked before
lumping. Default: TRUE.}

\item{mutmod}{A \code{mutationModel} object.}
}
\value{
A reduced mutation model. If the original matrix has dimensions
\eqn{n\times n}{n*n}, the result will be \eqn{k\times k}{k*k}, where \eqn{k
  = n - length(lump) + 1}.
}
\description{
Reduce a mutation matrix by combining a set of alleles into one "lump", if
this can be done without distorting the mutation process of the remaining
alleles. Such "allele lumping" can give dramatic efficiency improvements in
likelihood computations with multi-allelic markers, in cases where only some
of the alleles are observed in the pedigree.
}
\examples{
m = mutationMatrix("eq", alleles = 1:10, rate = 0.1)
afreq = rep(1/100, 100)

# Suppose only alleles 1 and 2 are observed.
# The following lumped matrix is then equivalent to `m`:
mLump = lumpedMatrix(m, afreq = afreq, lump = 3:10)
mLump

# Full model
mod = mutationModel("prop", alleles = 1:4, rate = 0.1, afreq = c(.1,.2,.3,.4))
mod2 = lumpedModel(mod, lump = 3:4)

}
