% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcpVector.R
\name{gcpVector}
\alias{gcpVector}
\title{Calculate module and azimuth}
\usage{
gcpVector(dx, dy)
}
\arguments{
\item{dx}{Numeric vector containing the difference on the \sQuote{x} coordinate between two sets
of GCP.}

\item{dy}{Numeric vector containing the difference on the \sQuote{y} coordinate between two sets
of GCP.}
}
\value{
A data frame containing the module, its square and azimuth. These three columns are named
\sQuote{module}, \sQuote{sq.module} and \sQuote{azimuth}.
}
\description{
Calculate the module and azimuth of the difference on x and y coordinates between two sets of
ground control points (GCP). It is suited to perform calculations for topographical
coordinates only. The origin is set in the y coordinate, and rotation performed clockwise.
}
\note{
This function was adapted from package's \strong{VecStatGraphs2D} function \code{LoadData()}.
}
\examples{
x <- gcpVector(dx = rnorm(3, 5, 10), dy = rnorm(3, 5, 10))

}
\references{
Ruiz-Cuetos J.C., Polo M.E. and Rodriguez P.G. (2012). \emph{VecStatGraphs2D: Vector analysis using
graphical and analytical methods in 2D}. R package version 1.6.
\url{https://CRAN.R-project.org/package=VecStatGraphs2D}.
}
\author{
Juan Carlos Ruiz Cuetos \email{bilba_t@hotmail.com}\cr Maria Eugenia Polo Garcia
\email{mepolo@unex.es}\cr Pablo Garcia Rodriguez \email{pablogr@unex.es}\cr Alessandro
Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
