% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pq_index.R
\name{pq_index}
\alias{pq_index}
\title{creating weighted index}
\usage{
pq_index(dt, x = "close|value", w = "cap_total", base_value = 1,
  base_date = NULL, name = NULL)
}
\arguments{
\item{dt}{a list/dataframe of time series dataset}

\item{x}{the name of column to create index. Default is 'close|value'}

\item{w}{the name of weights column. Default is 'cap_total'. If x is not available or is NULL, then using equal weights.}

\item{base_value}{the base value of index. Default is 1.}

\item{base_date}{the base date of index. Default is the minimum date.}

\item{name}{the name of index. Default is NULL, then using 'index'.}
}
\description{
\code{pq_index} creates a sector/industry index using the method of weighted geometric mean, based on a set of data and corresponding weights.
}
\examples{
\donttest{
# Example I bank share index
# load data
bank_symbol = c('601988', '601288', '601398', '601939', '601328')
bank_dat = md_stock(bank_symbol, source='163', date_range = 'max')

# creating index
bank_index = pq_index(bank_dat, x='close', w='cap_total')
# pq_plot(bank_index)

}

}
