% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_plot.R
\name{plot.ped}
\alias{plot.ped}
\alias{plot.singleton}
\alias{as_kinship2_pedigree}
\alias{plot.pedList}
\title{Plot pedigrees with genotypes}
\usage{
\method{plot}{ped}(x, marker = NULL, sep = "/", missing = "-",
  skip.empty.genotypes = FALSE, id.labels = labels(x), title = NULL,
  col = 1, shaded = NULL, deceased = NULL, starred = NULL,
  fouInb = "autosomal", margins = c(0.6, 1, 4.1, 1), keep.par = F,
  ...)

\method{plot}{singleton}(x, marker = NULL, sep = "/", missing = "-",
  skip.empty.genotypes = FALSE, id.labels = labels(x), title = NULL,
  col = 1, shaded = NULL, deceased = NULL, starred = NULL,
  fouInb = "autosomal", margins = c(8, 0, 0, 0), ...)

as_kinship2_pedigree(x, deceased = NULL, shaded = NULL)

\method{plot}{pedList}(x, ...)
}
\arguments{
\item{x}{a \code{\link[=ped]{ped()}} object.}

\item{marker}{either a vector of names or indices referring to markers
attached to \code{x}, a \code{marker} object, or a list of such. The genotypes for
the chosen markers are written below each individual in the pedigree, in
the format determined by \code{sep} and \code{missing}. See also
\code{skip.empty.genotypes} below. If NULL (the default), no genotypes are
plotted.}

\item{sep}{a character of length 1 separating alleles for diploid markers.}

\item{missing}{the symbol (integer or character) for missing alleles.}

\item{skip.empty.genotypes}{a logical. If TRUE, and \code{marker} is non-NULL,
empty genotypes (which by default looks like '-/-') are not printed.}

\item{id.labels}{a vector with labels for each pedigree member. This defaults
to \code{labels(x)}. Alternative forms:
\itemize{
\item If \code{id.labels} is NULL or the empty character "", then no labels are
drawn.
\item If \code{id.labels} is the word "num", then all individuals are numerically
labelled following the internal ordering.
\item If \code{id.labels} is a subset of \code{labels(x)}, then only this subset will be
labelled. If the vector is named, then the (non-empty) names are used
instead of the ID label. See Examples.
}}

\item{title}{the plot title. If NULL or '', no title is added to the plot.}

\item{col}{a vector of colours for the pedigree members, recycled if
necessary. Alternatively, \code{col} can be a list assigning colours to specific
members. For example if \code{col = list(red = "a", blue = c("b", "c"))} then
individual "a" will be red, "b" and "c" blue, and everyone else black. By
default everyone is drawn black.}

\item{shaded}{a vector of ID labels indicating pedigree members whose plot
symbols should appear shaded.}

\item{deceased}{a vector of ID labels indicating deceased pedigree members.}

\item{starred}{a vector of ID labels indicating pedigree members that should
be marked with a star in the pedigree plot.}

\item{fouInb}{either "autosomal" (default), "x" or NULL. If "autosomal" or
"x", inbreeding coefficients are added to the plot above the inbred
founders. If NULL, or if no founders are inbred, nothing is added.}

\item{margins}{a numeric of length 4 indicating the plot margins. For
singletons only the first element (the 'bottom' margin) is used.}

\item{keep.par}{A logical (default = FALSE). If TRUE, the graphical
parameters are not reset after plotting, which may be useful for adding
additional annotation.}

\item{\dots}{arguments passed on to \code{plot.pedigree} in the \code{kinship2}
package. In particular \code{symbolsize} and \code{cex} can be useful.}
}
\description{
This is the main function for pedigree plotting, with many options for
controlling the appearance of pedigree symbols and accompanying labels. Most
of the work is done by the plotting functionality in the 'kinship2' package.
}
\details{
\code{plot.ped} is in essence an elaborate wrapper for
\code{\link[kinship2:plot.pedigree]{kinship2::plot.pedigree()}}.
}
\examples{

x = nuclearPed(father = "fa", mother = "mo", child = "boy")
m = marker(x, fa = 1, boy = 1:2, name = "SNP")

plot(x, marker = m)

# Alternative syntax if the marker is attached to x
x = setMarkers(x, m)
plot(x, marker = "SNP")

# Other options
plot(x, marker = "SNP", shaded = typedMembers(x),
     starred = "fa", deceased = "mo")

# Labelling only some members
plot(x, id.labels = c("fa", "boy"))

# Labelling only some members, and renaming the father
plot(x, id.labels = c(FATHER = "fa", "boy"))

# Colours
plot(x, col = list(red = "fa", green = "boy"))

# Founder inbreeding is shown by default
founderInbreeding(x, "mo") = 0.1
plot(x)

# ... but can be suppressed
plot(x, fouInb = NULL)

}
\seealso{
\code{\link[kinship2:plot.pedigree]{kinship2::plot.pedigree()}}
}
\author{
Magnus Dehli Vigeland
}
