% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_allelematrix.R
\name{getAlleles}
\alias{getAlleles}
\alias{setAlleles}
\title{Allele matrix manipulation}
\usage{
getAlleles(x, ids = NULL, markers = NULL)

setAlleles(x, ids = NULL, markers = NULL, alleles)
}
\arguments{
\item{x}{A \code{ped} object or a list of such}

\item{ids}{A vector of ID labels. If NULL (default) all individuals are
included.}

\item{markers}{A vector of indices or names of markers attaches to \code{x}. If
NULL (default) all markers are included.}

\item{alleles}{A character of the same format and dimensions as the output of
\code{getAlleles(x, ids, markers)}, or an object which can be converted by
\code{as.matrix()} into such a matrix. See Details.}
}
\value{
\code{getAlleles()} returns a character matrix with \code{length(ids)} rows and
\code{2 * length(markers)} columns. The ID labels of \code{x} are used as rownames,
while the columns are named \verb{<m1>.1}, \verb{<m1>.2}, ... where \verb{<m1>} is the
name of the first marker, a.s.o.

\code{setAlleles()} returns a \code{ped} object identical to \code{x}, except for the
modified alleles. In particular, all locus attributes are unchanged.
}
\description{
Functions for getting and setting the genotypes of multiple
individuals/markers simultaneously
}
\details{
If the \code{alleles} argument of \code{setAlleles()} is not a matrix, it is recycled
(if necessary), and converted into a matrix of the correct dimensions. For
example, setting \code{alleles = 0} gives a simple way of removing the genotypes
of some or all individuals (while keeping the markers attached).
}
\examples{
# Setup: Pedigree with two markers
x = nuclearPed(1)
m1 = marker(x, `2` = "1/2", alleles = 1:2, name = "m1")
m2 = marker(x, `3` = "2/2", alleles = 1:2, name = "m2")
x = setMarkers(x, list(m1, m2))


# Extract allele matrix:

mat1 = getAlleles(x)
mat2 = getAlleles(x, ids = 2:3, markers = "m2")
stopifnot(identical(mat1[2:3, 3:4], mat2))

# Remove all genotypes
y = setAlleles(x, alleles = 0)
y

# Setting a single genotype
z = setAlleles(y, ids = "1", marker = "m2", alleles = 1:2)

# Alternative: In-place modification with `genotype()`
genotype(y, id = "1", marker = "m2") = 1:2
stopifnot(identical(y,z))


### Manipulation of pedlist objects
s = transferMarkers(x, singleton("s"))
peds = list(x, s)

getAlleles(peds)

setAlleles(peds, ids = "s", marker = "m1", alleles = 1:2)

}
\seealso{
\code{\link[=transferMarkers]{transferMarkers()}}
}
