% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_utils.R
\name{getComponent}
\alias{getComponent}
\title{Pedigree component}
\usage{
getComponent(x, ids, checkUnique = FALSE, errorIfUnknown = FALSE)
}
\arguments{
\item{x}{A list of \code{ped} objects}

\item{ids}{A vector of ID labels (coercible to character)}

\item{checkUnique}{If TRUE an error is raised if any element of \code{ids} occurs
more than once in \code{x}. Default: FALSE.}

\item{errorIfUnknown}{If TRUE, the function stops with an error if not all
elements of \code{ids} are recognised as names of members in \code{x}. Default:
FALSE.}
}
\value{
An integer vector of the same length as \code{ids}, with NA entries where
the corresponding label was not found in any of the components.
}
\description{
Given a list of \code{ped} objects (called pedigree components), and a vector of
ID labels, find the index of the component holding each individual.
}
\examples{
x = list(nuclearPed(1), singleton(id = "A"))
getComponent(x, c(3, "A"))

}
\seealso{
\code{\link[=internalID]{internalID()}}
}
