% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penetrance-package.R, R/penetranceMain.R
\docType{package}
\name{penetrance}
\alias{penetrance}
\alias{penetrance-package}
\title{penetrance: A Package for Penetrance Estimation}
\usage{
penetrance(
  pedigree,
  twins = NULL,
  n_chains = 1,
  n_iter_per_chain = 10000,
  ncores = 6,
  max_age = 94,
  baseline_data = baseline_data_default,
  remove_proband = FALSE,
  age_imputation = FALSE,
  median_max = TRUE,
  BaselineNC = TRUE,
  var = c(0.1, 0.1, 2, 2, 5, 5, 5, 5),
  burn_in = 0,
  thinning_factor = 1,
  imp_interval = 100,
  distribution_data = distribution_data_default,
  prev = 1e-04,
  sample_size = NULL,
  ratio = NULL,
  prior_params = prior_params_default,
  risk_proportion = risk_proportion_default,
  summary_stats = TRUE,
  rejection_rates = TRUE,
  density_plots = TRUE,
  plot_trace = TRUE,
  penetrance_plot = TRUE,
  penetrance_plot_pdf = TRUE,
  plot_loglikelihood = TRUE,
  plot_acf = TRUE,
  probCI = 0.95,
  sex_specific = TRUE
)
}
\arguments{
\item{pedigree}{A data frame containing the pedigree data in the required format. It should include the following columns:
\itemize{
\item \code{PedigreeID}: A numeric value representing the unique identifier for each family. There should be no duplicated entries.
\item \code{ID}: A numeric value representing the unique identifier for each individual. There should be no duplicated entries.
\item \code{Sex}: A numeric value where \code{0} indicates female and \code{1} indicates male. Unknown sex needs to be coded as \code{NA}.
\item \code{MotherID}: A numeric value representing the unique identifier for an individual's mother.
\item \code{FatherID}: A numeric value representing the unique identifier for an individual's father.
\item \code{isProband}: A numeric value where \code{1} indicates the individual is a proband and \code{0} otherwise.
\item \code{CurAge}: A numeric value indicating the age of censoring (current age if the person is alive or age at death if the person is deceased). Allowed ages range from \code{1} to \code{94}. Unknown ages can be left empty or coded as \code{NA}.
\item \code{isAff}: A numeric value indicating the affection status of cancer, with \code{1} for diagnosed individuals,
\code{0} for unaffected individuals, and \code{NA} for unknown status.
\item \code{Age}: A numeric value indicating the age of cancer diagnosis, encoded as \code{NA} if the individual was not diagnosed. Allowed ages range from \code{1} to \code{94}. Unknown ages can be left empty or coded as \code{NA}.
\item \code{geno}: A column for germline testing or tumor marker testing results. Positive results should be coded as \code{1}, negative results as \code{0}, and unknown results as \code{NA} or left empty.
}}

\item{twins}{A list specifying identical twins or triplets in the family. For example, to indicate that "ora024" and "ora027" are identical twins, and "aey063" and "aey064" are identical twins, use the following format: \code{twins <- list(c("ora024", "ora027"), c("aey063", "aey064"))}.}

\item{n_chains}{Integer, the number of chains for parallel computation. Default is 1.}

\item{n_iter_per_chain}{Integer, the number of iterations for each chain. Default is 10000.}

\item{ncores}{Integer, the number of cores for parallel computation. Default is 6.}

\item{max_age}{Integer, the maximum age considered for analysis. Default is 94.}

\item{baseline_data}{Data for the baseline risk estimates (probability of developing cancer), such as population-level risk from a cancer registry. Default data, for exemplary purposes, is for Colorectal cancer from the SEER database.}

\item{remove_proband}{Logical, indicating whether to remove probands from the analysis. Default is FALSE.}

\item{age_imputation}{Logical, indicating whether to perform age imputation. Default is FALSE.}

\item{median_max}{Logical, indicating whether to use the baseline median age or \code{max_age} as an upper bound for the median proposal. Default is TRUE.}

\item{BaselineNC}{Logical, indicating that the non-carrier penetrance is assumed to be the baseline penetrance. Default is TRUE.}

\item{var}{Numeric vector, variances for the proposal distribution in the Metropolis-Hastings algorithm. Default is \code{c(0.1, 0.1, 2, 2, 5, 5, 5, 5)}.}

\item{burn_in}{Numeric, the fraction of results to discard as burn-in (0 to 1). Default is 0 (no burn-in).}

\item{thinning_factor}{Integer, the factor by which to thin the results. Default is 1 (no thinning).}

\item{imp_interval}{Integer, the interval at which age imputation should be performed when age_imputation = TRUE.}

\item{distribution_data}{Data for generating prior distributions.}

\item{prev}{Numeric, prevalence of the carrier status. Default is 0.0001.}

\item{sample_size}{Optional numeric, sample size for distribution generation.}

\item{ratio}{Optional numeric, ratio parameter for distribution generation.}

\item{prior_params}{List, parameters for prior distributions.}

\item{risk_proportion}{Numeric, proportion of risk for distribution generation.}

\item{summary_stats}{Logical, indicating whether to include summary statistics in the output. Default is TRUE.}

\item{rejection_rates}{Logical, indicating whether to include rejection rates in the output. Default is TRUE.}

\item{density_plots}{Logical, indicating whether to include density plots in the output. Default is TRUE.}

\item{plot_trace}{Logical, indicating whether to include trace plots in the output. Default is TRUE.}

\item{penetrance_plot}{Logical, indicating whether to include penetrance plots in the output. Default is TRUE.}

\item{penetrance_plot_pdf}{Logical, indicating whether to include PDF plots in the output. Default is TRUE.}

\item{plot_loglikelihood}{Logical, indicating whether to include log-likelihood plots in the output. Default is TRUE.}

\item{plot_acf}{Logical, indicating whether to include autocorrelation function (ACF) plots for posterior samples. Default is TRUE.}

\item{probCI}{Numeric, probability level for credible intervals in penetrance plots. Must be between 0 and 1. Default is 0.95.}

\item{sex_specific}{Logical, indicating whether to use sex-specific parameters in the analysis. Default is TRUE.}
}
\value{
A list containing combined results from all chains, including optional statistics and plots.
}
\description{
A comprehensive package for penetrance estimation in family-based studies. This package
implements Bayesian methods using Metropolis-Hastings algorithm for estimating age-specific
penetrance of genetic variants. It supports both sex-specific and non-sex-specific analyses,
and provides various visualization tools for examining MCMC results.

This function implements the Independent Metropolis-Hastings algorithm for Bayesian
penetrance estimation of cancer risk. It utilizes parallel computing to run multiple
chains and provides various options for analyzing and visualizing the results.
}
\details{
Key features:
\itemize{
\item Bayesian estimation of penetrance using family-based data
\item Support for sex-specific and non-sex-specific analyses
\item Age imputation for missing data
\item Visualization tools for MCMC diagnostics
\item Integration with the clipp package for likelihood calculations
}
}
\examples{
# Create example baseline data (simplified for demonstration)
baseline_data_default <- data.frame(
  Age = 1:94,
  Female = rep(0.01, 94),
  Male = rep(0.01, 94)
)

# Create example distribution data
distribution_data_default <- data.frame(
  Age = 1:94,
  Risk = rep(0.01, 94)
)

# Create example prior parameters
prior_params_default <- list(
  shape = 2,
  scale = 50
)

# Create example risk proportion
risk_proportion_default <- 0.5

# Create a simple example pedigree
example_pedigree <- data.frame(
  PedigreeID = rep(1, 4),
  ID = 1:4,
  Sex = c(1, 0, 1, 0),  # 1 for male, 0 for female
  MotherID = c(NA, NA, 2, 2),
  FatherID = c(NA, NA, 1, 1),
  isProband = c(0, 0, 1, 0),
  CurAge = c(70, 68, 45, 42),
  isAff = c(0, 0, 1, 0),
  Age = c(NA, NA, 40, NA),
  geno = c(NA, NA, 1, NA)
)

# Basic usage with minimal iterations
result <- penetrance(
  pedigree = list(example_pedigree),
  n_chains = 1,
  n_iter_per_chain = 10,  # Very small number for example
  ncores = 1,             # Single core for example
  summary_stats = TRUE,
  plot_trace = FALSE,     # Disable plots for quick example
  density_plots = FALSE,
  penetrance_plot = FALSE,
  penetrance_plot_pdf = FALSE,
  plot_loglikelihood = FALSE,
  plot_acf = FALSE
)

# View basic results
head(result$summary_stats)

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/nicokubi/penetrance}
  \item \url{https://nicokubi.github.io/penetrance/}
}

}
\author{
\strong{Maintainer}: Nicolas Kubista \email{bmendel@jimmy.harvard.edu}

Authors:
\itemize{
  \item BayesMendel Lab
}

}
