% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penhdfeppml_int.R
\name{penhdfeppml_int}
\alias{penhdfeppml_int}
\title{One-Shot Penalized PPML Estimation with HDFE}
\usage{
penhdfeppml_int(
  y,
  x,
  fes,
  lambda,
  tol = 1e-08,
  hdfetol = 1e-04,
  glmnettol = 1e-12,
  penalty = "lasso",
  penweights = NULL,
  saveX = TRUE,
  mu = NULL,
  colcheck = TRUE,
  init_z = NULL,
  post = FALSE,
  verbose = FALSE,
  standardize = TRUE,
  method = "placeholder",
  cluster = NULL,
  debug = FALSE
)
}
\arguments{
\item{y}{Dependent variable (a vector)}

\item{x}{Regressor matrix.}

\item{fes}{List of fixed effects.}

\item{lambda}{Penalty parameter (a number).}

\item{tol}{Tolerance parameter for convergence of the IRLS algorithm.}

\item{hdfetol}{Tolerance parameter for the within-transformation step,
passed on to \code{collapse::fhdwithin}.}

\item{glmnettol}{Tolerance parameter to be passed on to \code{glmnet::glmnet}.}

\item{penalty}{A string indicating the penalty type. Currently supported: "lasso" and "ridge".}

\item{penweights}{Optional: a vector of coefficient-specific penalties to use in plugin lasso when
\code{method == "plugin"}.}

\item{saveX}{Logical. If \code{TRUE}, it returns the values of x and z after partialling out the
fixed effects.}

\item{mu}{Optional: initial values of the conditional mean \eqn{\mu}, to be used as weights in the
first iteration of the algorithm.}

\item{colcheck}{Logical. If \code{TRUE}, checks for perfect multicollinearity in \code{x}.}

\item{init_z}{Optional: initial values of the transformed dependent variable, to be used in the
first iteration of the algorithm.}

\item{post}{Logical. If \code{TRUE}, estimates a post-penalty regression with the selected variables.}

\item{verbose}{Logical. If \code{TRUE}, it prints information to the screen while evaluating.}

\item{standardize}{Logical. If \code{TRUE}, x variables are standardized before estimation.}

\item{method}{The user can set this equal to "plugin" to perform the plugin algorithm with
coefficient-specific penalty weights (see details). Otherwise, a single global penalty is used.}

\item{cluster}{Optional: a vector classifying observations into clusters (to use when calculating SEs).}

\item{debug}{Logical. If \code{TRUE}, this helps with debugging penalty weights by printing output
of the first iteration to the console and stopping the estimation algorithm.}
}
\value{
If \code{method == "lasso"} (the default), an object of class \code{elnet} with the elements
described in \link[glmnet]{glmnet}, as well as:
\itemize{
\item \code{mu}: a 1 x \code{length(y)} matrix with the final values of the conditional mean \eqn{\mu}.
\item \code{deviance}.
\item \code{bic}: Bayesian Information Criterion.
\item \code{phi}: coefficient-specific penalty weights (only if \code{method == "plugin"}.
\item \code{x_resid}: matrix of demeaned regressors.
\item \code{z_resid}: vector of demeaned (transformed) dependent variable.
}
If \code{method == "ridge"}, a list with the following elements:
\itemize{
\item \code{beta}: a 1 x \code{ncol(x)} matrix with coefficient (beta) estimates.
\item \code{mu}: a 1 x \code{length(y)} matrix with the final values of the conditional mean \eqn{\mu}.
\item \code{deviance}.
\item \code{bic}: Bayesian Information Criterion.
\item \code{x_resid}: matrix of demeaned regressors.
\item \code{z_resid}: vector of demeaned (transformed) dependent variable.
}
}
\description{
\code{penhdfeppml_int} is the internal algorithm called by \code{penhdfeppml} to fit a penalized PPML
regression for a given type of penalty and a given value of the penalty parameter. It takes a vector
with the dependent variable, a regressor matrix and a set of fixed effects (in list form: each element
in the list should be a separate HDFE). The penalty can be either lasso or ridge, and the plugin
method can be enabled via the \code{method} argument.
}
\details{
More formally, \code{penhdfeppml_int} performs iteratively re-weighted least squares (IRLS) on a
transformed model, as described in Breinlich, Corradi, Rocha, Ruta, Santos Silva and Zylkin (2020).
In each iteration, the function calculates the transformed dependent variable, partials out the fixed
effects (calling \code{collapse::fhdwithin}) and then and then calls \code{glmnet::glmnet} if the selected
penalty is lasso (the default). If the user selects ridge, the analytical solution is instead
computed directly using fast C++ implementation.

For information on the plugin lasso method, see \link{penhdfeppml_cluster_int}.
}
\section{References}{

Breinlich, H., Corradi, V., Rocha, N., Ruta, M., Santos Silva, J.M.C. and T. Zylkin (2021).
"Machine Learning in International Trade Research: Evaluating the Impact of Trade Agreements",
Policy Research Working Paper; No. 9629. World Bank, Washington, DC.

Correia, S., P. Guimaraes and T. Zylkin (2020). "Fast Poisson estimation with high dimensional
fixed effects", \emph{STATA Journal}, 20, 90-115.

Gaure, S (2013). "OLS with multiple high dimensional category variables",
\emph{Computational Statistics & Data Analysis}, 66, 8-18.

Friedman, J., T. Hastie, and R. Tibshirani (2010). "Regularization paths for generalized linear
models via coordinate descent", \emph{Journal of Statistical Software}, 33, 1-22.

Belloni, A., V. Chernozhukov, C. Hansen and D. Kozbur (2016). "Inference in high dimensional panel
models with an application to gun control", \emph{Journal of Business & Economic Statistics}, 34, 590-605.
}

\examples{
# To reduce run time, we keep only countries in the Americas:
americas <- countries$iso[countries$region == "Americas"]
trade <- trade[(trade$imp \%in\% americas) & (trade$exp \%in\% americas), ]
# Now generate the needed x, y and fes objects:
y <- trade$export
x <- data.matrix(trade[, -1:-6])
fes <- list(exp_time = interaction(trade$exp, trade$time),
            imp_time = interaction(trade$imp, trade$time),
            pair     = interaction(trade$exp, trade$imp))
# Finally, we try penhdfeppml_int with a lasso penalty (the default):
reg <- penhdfeppml_int(y = y, x = x, fes = fes, lambda = 0.1)

# We can also try ridge:
\donttest{reg <- penhdfeppml_int(y = y, x = x, fes = fes, lambda = 0.1, penalty = "ridge")}

}
