% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef-methods.R
\name{coef.pense_cvfit}
\alias{coef.pense_cvfit}
\title{Extract Coefficient Estimates}
\usage{
\method{coef}{pense_cvfit}(
  object,
  lambda = c("min", "se"),
  se_mult = 1,
  sparse = NULL,
  exact = deprecated(),
  correction = deprecated(),
  ...
)
}
\arguments{
\item{object}{PENSE with cross-validated hyper-parameters to extract coefficients from.}

\item{lambda}{either a string specifying which penalty level to use (\code{"min"} or \code{"se"}) or a a single numeric
value of the penalty parameter. See details.}

\item{se_mult}{If \code{lambda = "se"}, the multiple of standard errors to tolerate.}

\item{sparse}{should coefficients be returned as sparse or dense vectors? Defaults to the \code{sparse} argument
supplied to \code{\link[=pense_cv]{pense_cv()}}. Can also be set to \code{sparse = 'matrix'}, in which case a sparse matrix
is returned instead of a sparse vector.}

\item{exact}{deprecated. Always gives a warning if \code{lambda} is not part of the fitted sequence and coefficients
are interpolated.}

\item{correction}{defunct.}

\item{...}{currently not used.}
}
\value{
either a numeric vector or a sparse vector of type \link[Matrix:sparseVector-class]{dsparseVector}
of size \eqn{p + 1}, depending on the \code{sparse} argument.
Note: prior to version 2.0.0 sparse coefficients were returned as sparse matrix of type \emph{dgCMatrix}.
To get a sparse matrix, use \code{sparse = 'matrix'}.
}
\description{
Extract coefficients from a PENSE (or LS-EN) regularization path with hyper-parameters chosen by cross-validation.
}
\details{
If \code{lambda = "se"} and \code{object} contains fitted estimates for every penalization level in the sequence, extract the
coefficients of the most parsimonious model with prediction performance statistically indistinguishable from the best
model. This is determined to be the model with prediction performance within \code{se_mult * cv_se} from the best model.
}
\examples{
# Compute the PENSE regularization path for Freeny's revenue data
# (see ?freeny)
data(freeny)
x <- as.matrix(freeny[ , 2:5])

regpath <- pense(x, freeny$y, alpha = 0.5)
plot(regpath)

# Extract the coefficients at a certain penalization level
coef(regpath, lambda = regpath$lambda[40])

# What penalization level leads to good prediction performance?
cv_results <- pense_cv(x, freeny$y, alpha = 0.5, cv_repl = 2,
                       cv_k = 4)
plot(cv_results, se_mult = 1)

# Extract the coefficients at the penalization level with
# smallest prediction error ...
coef(cv_results)
# ... or at the penalization level with prediction error
# statistically indistinguishable from the minimum.
coef(cv_results, lambda = 'se')
}
\seealso{
Other functions for extracting components: 
\code{\link{coef.pense_fit}()},
\code{\link{predict.pense_cvfit}()},
\code{\link{predict.pense_fit}()},
\code{\link{residuals.pense_cvfit}()},
\code{\link{residuals.pense_fit}()}
}
\concept{functions for extracting components}
