% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_rate.R
\name{error_rate}
\alias{error_rate}
\title{Error Rate for Logistic Regression Models}
\usage{
error_rate(model)
}
\arguments{
\item{model}{A \code{glm}-object with binomial-family.}
}
\value{
A list with four values: the error rate of the full and the null model,
    as well as the chi-squared and p-value from the Likelihood-Ratio-Test
    between the full and null model.
}
\description{
Compute the error rate for logistic regression models, which is
   a crude measure for the model fit.
}
\details{
The error rate is a crude measure for model fit for logistic regression
   models. It is defined as the proportion of cases for which the
   deterministic prediction is wrong, i.e. the proportion where the the
   predicted probability is above 0.5, although y = 0 (and vice versa).
   In general, the error rate should be below 0.5 (i.e. 50\%), the
   closer to zero, the better. Furthermore, the error rate of the full
   model should be considerably below the null model's error rate
   (cf. Gelman and Hill 2007, pp. 99).
}
\examples{
data(mtcars)
m <- glm(am ~ mpg + hp + cyl, data = mtcars, family= binomial)
error_rate(m)

}
\references{
Gelman, A., & Hill, J. (2007). Data analysis using regression and multilevel/hierarchical models. Cambridge; New York: Cambridge University Press.
}
