% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_outliers.R
\name{check_outliers}
\alias{check_outliers}
\alias{check_outliers.default}
\title{Check for influential observations}
\usage{
check_outliers(x, ...)

\method{check_outliers}{default}(x, threshold = 4/insight::n_obs(x), ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}

\item{threshold}{The threshold indicating at which distance an observation is
considered as outlier. For the Cook's Distance method, \code{threshold} defaults
to 4 divided by numbers of observations.}
}
\value{
Check (message) on whether outliers were detected or not, as well as a
data frame (with the original data that was used to fit the model), including
information on the distance measure and whether or not an observation is considered
as outlier.
}
\description{
Checks for and locates influential observations (i.e., "outliers") via Cook's Distance.
}
\details{
Performs a Cook's distance test to check for influential observations. Those greater than 4/n, are considered
outliers. This relatively conservative threshold is useful only for detection, rather than justificaiton for automatic observation
deletion. If users opt to drop observations that may be problematic, they may do so by specifying \code{drop_outliers = TRUE}.
}
\examples{
# select only mpg and disp (continuous)
mt1 <- mtcars[, c(1,3)]
# create some fake outliers and attach outliers to main df
mt2 <- rbind(mt1, data.frame(mpg = c(37, 40), disp = c(300, 400)))
# fit model with outliers
model <- lm(disp ~ mpg, data = mt2)

check_outliers(model)

}
\references{
Cook, R. D. (1977). Detection of influential observation in linear regression. Technometrics, 19(1), 15-18.
}
