\name{CvSettings-class}
\Rdversion{1.1}
\docType{class}
\alias{CvSettings}
\alias{CvSettings-class}
\alias{show,CvSettings-method}

\title{Class "CvSettings"}
\description{	This class of objects contains the information
  describing a cross validation experiment, i.e. its settings.}
\section{Objects from the Class}{
  Objects can be created by calls of the form \code{CvSettings(...)}
  providing the values for the class slots. 
  These objects include information on the number of repetitions of the
  cross validation (CV) experiment, the number of folds, the random number generator seed,
  whether the sampling should or not be stratified and \emph{optionally}, the
  concrete data splits to use on each repetition and iteration of the CV
  experiment. Note that most of the times you will not supply these data
  splits as the CV routines in this infra-structure will take care of
  building them. Still, this allows you to  replicate some experiment
  carried out with specific train/test splits.
}
\section{Slots}{
  \describe{
    \item{\code{nReps}:}{Object of class \code{numeric} indicating
      the number of repetitions of the N folds CV experiment (defaulting
      to 1). }
    \item{\code{nFolds}:}{Object of class \code{numeric} with the
      number of folds on each CV experiment (defaulting to 10). }
    \item{\code{seed}:}{Object of class \code{numeric} with the
      random number generator seed (defaulting to 1234). }
    \item{\code{strat}:}{Object of class \code{logical} indicating
      whether the sampling should or not be stratified (defaulting to FALSE). }
    \item{\code{dataSplits}:}{Object of class \code{list} or \code{NULL}
      containing the data splits to use on each repetition of a
      CV experiment (defaulting to \code{NULL}). This list
      should contain as many elements as there are repetitions of the CV
      experiment. Each element should be a matrix with as many rows as
      there are cases in the data sample used in the experiment, and as
      many columns as there are folds in CV experiment. Each column of
      this matrix should contain 1's and 0's, with 1's on rows that are
      part of the test set of the corresponding fold, and 0's in the
      rows that are to be used as training cases in that fold. }
  }
}
\section{Extends}{
Class \code{\linkS4class{EstimationSettings}}, directly.
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "CvSettings")}: method used to
      show the contents of a \code{CvSettings} object. }
	 }
       }
\references{ Torgo, L. (2013) \emph{An Infra-Structure for Performance
    Estimation and Experimental Comparison on Predictive Models}.
  \url{https://github.com/ltorgo/performanceEstimation}  
}
\author{ Luis Torgo \email{ltorgo@dcc.fc.up.pt} }
\seealso{
   \code{\linkS4class{McSettings}},
  \code{\linkS4class{LoocvSettings}}, \code{\linkS4class{BootSettings}},\code{\linkS4class{HldSettings}}, \code{\linkS4class{EstimationSettings}}
}
\examples{
showClass("CvSettings")

s1 <- CvSettings(nReps=2,nFolds=5,strat=TRUE)

## small example illustrating the format of user supplied data splits
## it assumes that the source data is formed by 10 cases and that we
## will be using a single repetition of a 2-fold CV process
s2 <- CvSettings(dataSplits=list(matrix(c(rep(0,5),rep(1,5),
                                          rep(1,5),rep(0,5)),
                                        nrow=10,ncol=2)))
s2
s2@dataSplits
}
\keyword{classes}
