% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{bases2genotypes}
\alias{bases2genotypes}
\title{Transform bases into genotypes}
\usage{
bases2genotypes(input, ploidy)
}
\arguments{
\item{input}{Matrix of genotype bases. Rows represent the individual markers. 
Columns represent samples, dependenden on the ploidy.}

\item{ploidy}{Ploidy level of the organism. 
Influences how many columns are collapsed into one.}
}
\value{
Matrix of genotypes. 
The number of columns is 1/\code{ploidy} of the \code{input}.
}
\description{
Preprocess the input data in case bases are provided instead of genotypes
}
\examples{
data(simTetra)
bases2genotypes(simTetra, 4)
}

