% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{clusterperm.lmer}
\alias{clusterperm.lmer}
\title{Cluster-based permutation tests for time series data, based on mixed-effects models or other \code{buildmer} models.}
\usage{
clusterperm.lmer(
  formula,
  data = NULL,
  family = gaussian(),
  weights = NULL,
  offset = NULL,
  series.var = ~0,
  buildmerControl = list(direction = "order", crit = "LRT", quiet = TRUE, ddf = "lme4"),
  nperm = 1000,
  type = "regression",
  parallel = FALSE,
  progress = "none"
)
}
\arguments{
\item{formula}{A normal formula, possibly using \code{lme4}-style random effects. This can also be a buildmer terms object, provided \code{dep} is passed in \code{buildmerControl}. Only a single response variable is supported. For binomial models, the \code{cbind} syntax is not supported; please convert your dependent variable to a proportion and use weights instead.}

\item{data}{The data.}

\item{family}{The family.}

\item{weights}{An optional vector of prior case weights. This vector is evaluated in the calling environment, not in the formula or data frame!}

\item{offset}{An optional vector containing a prior offset term. This vector is evaluated in the calling environment, not in the formula or data frame!}

\item{series.var}{A one-sided formula giving the variable grouping the time series.}

\item{buildmerControl}{Options overriding the defaults in \code{buildmerControl}.}

\item{nperm}{The number of permutations.}

\item{type}{A character string of either \code{'anova'} or \code{'regression'}. The former runs an analysis of variance and returns F-values and p-values based on the explained variance of each factor in the design. The latter runs a linear-regression analysis and returns t-values and p-values based on individual effects. When running ANOVA, it is advised to use orthogonal predictors, as type III sums of squares are used.}

\item{parallel}{Whether to parallelize the permutation testing using plyr's \code{parallel} option. Needs some additional set-up; see the plyr documentation.}

\item{progress}{A plyr \code{.progress} bar name, see the plyr documentation. If not \code{'none'} while \code{parallel=TRUE}, an ad-hoc solution will be used, which will be visible if the cluster nodes were created with \code{outfile=''}.}
}
\value{
A data frame.
}
\description{
Cluster-based permutation tests for time series data, based on mixed-effects models or other \code{buildmer} models.
}
\details{
If not explicitly overridden in the \code{buildmerControl} argument, the function changes a few buildmer defaults to make more sense for permutation testing. This includes setting \code{direction='order'} and \code{quiet=TRUE}. Set these options explicitly to override this behavior.
Because model comparisons are used for efficient permutation testing, REML is not supported.
Omega squared is not available for mixed-effects ANOVA; the \code{w2} column will not be included in the resulting \code{permutes} object.
The returned object provides the raw bootstrap samples in the \code{pb} attribute. These are used to compute a corrected p-value using Maris & Oostenveld's (2007) cluster mass statistic, but can also be used by the user to compute other such statistics. These obviously significantly increase the size of the R object; if this becomes a problem, there is no harm in deleting them using e.g. \code{attr(x,'perms') <- NULL}.
}
\examples{
\donttest{
# Testing a single EEG electrode, with random effects by participants
perms <- clusterperm.lmer(Fz ~ Deviant * Session + (Deviant * Session | Subject),
	data=MMN,series.var=~Time)
# Testing a single EEG electrode, with random effects by participants, ANOVA inference
perms <- clusterperm.lmer(Fz ~ Deviant * Session + (Deviant * Session | Subject),
	data=MMN,series.var=~Time,type='anova')
}
\dontshow{
perms <- clusterperm.lmer(Fz ~ Deviant*Session + (1|Subject),data=MMN[MMN$Time > 200 & MMN$Time < 205,],series.var=~Time,nperm=2,type='anova')
perms <- clusterperm.lmer(Fz ~ Deviant*Session + (1|Subject),data=MMN[MMN$Time > 200 & MMN$Time < 205,],series.var=~Time,nperm=2,type='regression')
perms <- clusterperm.lmer(Fz ~ Session + (1|ppn),data=within(MMN[MMN$Time > 200 & MMN$Time < 205,],{Session <- factor(Session)}),series.var=~Time,nperm=2,type='regression')
}
}
