% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_explore.R
\name{pm_list_families}
\alias{pm_list_families}
\title{List taxonomic families in the Peruvian mammal backbone}
\usage{
pm_list_families(order = NULL)
}
\arguments{
\item{order}{Optional character vector specifying one or more taxonomic
orders to include. If \code{NULL} (default), all orders are included.
Order names are case-sensitive (e.g., "Rodentia", "Chiroptera").}
}
\value{
A tibble with one row per family, arranged by order and family name,
with the following columns:
\describe{
\item{order}{Taxonomic order}
\item{family}{Family name}
\item{n_genera}{Number of genera in the family}
\item{n_species}{Number of species in the family}
\item{n_endemic}{Number of endemic species to Peru in the family}
}
}
\description{
Summarises the number of genera, species and endemic species per family.
Optionally filters the output to one or more taxonomic orders.
}
\examples{
# All families
pm_list_families()

# Only families within Rodentia
pm_list_families(order = "Rodentia")

# Multiple orders
pm_list_families(order = c("Rodentia", "Chiroptera"))

}
