#This may need checking on other systems, because I'm using exact value checks with no consideration of precision...
#Setup
require(testthat)
require(pez)
require(picante)
data(phylocom)
data <- comparative.comm(phylocom$phylo, phylocom$sample, warn=FALSE)
context("shape metrics")

#Tests
test_that("PSV", {
  psv_test <<- shape(data, "psv")
  expect_that(psv_test$psv, equals(c(0.485714285714286, 0.6, 0.714285714285714, 0.828571428571429, 0.885714285714286, 0.842857142857143)))
  for(i in seq_along(psv_test))
      if(!names(psv_test)[i] %in% c("type","coefs","psv"))
          expect_that(psv_test[[i]], equals(NULL))
})
test_that("PSR", {
  psr_test <<- shape(data, "psr")
  for(i in seq_along(psr_test))
      if(!names(psr_test)[i] %in% c("type","coefs","psr"))
          expect_that(psr_test[[i]], equals(NULL))
  expect_that(psr_test$psr, equals(c(3.88571428571429, 4.8, 5.71428571428571, 6.62857142857143, 7.08571428571429, 6.74285714285714)))
  expect_that(psr_test$psr, equals(psr_test$coefs$psr))
})
test_that("MPD", {
  mpd_test <<- shape(data, "mpd")
  for(i in seq_along(mpd_test))
      if(!names(mpd_test)[i] %in% c("type","coefs","mpd"))
          expect_that(mpd_test[[i]], equals(NULL))
  expect_that(mpd_test$mpd, equals(c(4.85714285714286, 6, 7.14285714285714, 8.28571428571429, 8.85714285714286, 8.42857142857143)))
  expect_that(mpd_test$mpd, equals(mpd_test$coefs$mpd))
})
test_that("MNTD", {
  mntd_test <<- shape(data, "mntd")
  for(i in seq_along(mntd_test))
      if(!names(mntd_test)[i] %in% c("type","coefs","mntd"))
          expect_that(mntd_test[[i]], equals(NULL))
  expect_that(mntd_test$mntd, equals(mntd(data$comm, cophenetic(data$phy))))
})
test_that("PD", {
  pd_test <<- shape(data, "pd")
  for(i in seq_along(pd_test))
      if(!names(pd_test)[i] %in% c("type","coefs","pd", "pd.ivs"))
          expect_that(pd_test[[i]], equals(NULL))
  expect_that(pd_test$pd, equals(c(16, 17, 18, 22, 30, 27)))
  expect_that(pd_test$pd.ivs, is_equivalent_to(c(-5.66666666666666, -4.66666666666667, -3.66666666666667, 0.333333333333332, 8.33333333333333, 5.33333333333333)))
  expect_that(pd_test$pd, is_equivalent_to(pd_test$coefs$pd))
  expect_that(pd_test$pd.ivs, is_equivalent_to(pd_test$coefs$pd.ivs))
})
test_that("Colless", {
  colless_test <<- shape(data, "colless")
  for(i in seq_along(colless_test))
      if(!names(colless_test)[i] %in% c("type","coefs","colless"))
          expect_that(colless_test[[i]], equals(NULL))
  expect_that(colless_test$colless, is_equivalent_to(c(0, 0, 0, 0, 0, 5)))
  expect_that(colless_test$colless, is_equivalent_to(colless_test$coefs$colless))
})
test_that("Gamma", {
  gamma_test <<- shape(data, "gamma")
  for(i in seq_along(gamma_test))
      if(!names(gamma_test)[i] %in% c("type","coefs","gamma"))
          expect_that(gamma_test[[i]], equals(NULL))
  expect_that(gamma_test$gamma, is_equivalent_to(c(-1.41421356237309, -0.707106781186547, -0.157134840263678, 
-0.385694607919935, -2.9227080289044, -2.19988776369148)))
  expect_that(gamma_test$gamma, is_equivalent_to(gamma_test$coefs$gamma))
})
test_that("Taxon", {
  taxon_test <<- shape(data, "taxon")
  for(i in seq_along(taxon_test))
      if(!names(taxon_test)[i] %in% c("type","coefs","taxon"))
          expect_that(taxon_test[[i]], equals(NULL))
  t <- data
  t$comm[t$comm > 0] <- 1
  expect_that(taxon_test$taxon, equals(taxondive(t$comm, cophenetic(data$phy))))
  expect_that(taxon_test$coefs$Delta, is_equivalent_to(taxon_test$taxon$D[1:6]))
  expect_that(taxon_test$coefs$DeltaStar, is_equivalent_to(taxon_test$taxon$Dstar[1:6]))
  expect_that(taxon_test$coefs$LambdaPlus, is_equivalent_to(taxon_test$taxon$Lambda[1:6]))
  expect_that(taxon_test$coefs$DeltaPlus, is_equivalent_to(taxon_test$taxon$Dplus[1:6]))
  expect_that(taxon_test$coefs$S.DeltaPlus, is_equivalent_to(taxon_test$taxon$SDplus[1:6]))
})
test_that("Eigenvectors", {
  set.seed(123)
  warn <- options("warn")
  eigen.sum <<- shape(data, "eigen.sum")
  for(i in seq_along(eigen.sum))
      if(!names(eigen.sum)[i] %in% c("type","coefs","eigen.sum"))
          expect_that(eigen.sum[[i]], equals(NULL))
  expect_that(eigen.sum$eigen.sum, is_equivalent_to(c(1.85989806057967e-32, 9.80257655161354e-05, 0.0580509448862977, 0.0456171567606935, 0.0434666292330911, 0.0476659578856296)))
  set.seed(123)
  expect_that(shape(data, "eigen.sum", which.eigen=2)$eigen.sum, is_equivalent_to(c(3.30159419037812e-32, 0.082086748214039, 0.0137252988148037, 0.0415764004365078, 0.0384905400587625, 0.0452932152543931)))
  expect_that(eigen.sum$eigen.sum, is_equivalent_to(eigen.sum$coefs$eigen.sum))
  expect_that(options("warn"), is_equivalent_to(warn))
})
test_that("EED", {
  eed <<- shape(data, "eed")
  for(i in seq_along(eed))
      if(!names(eed)[i] %in% c("type","coefs","Eed"))
          expect_that(eed[[i]], equals(NULL))
  expect_that(eed$Eed, equals(c(3.202317, 3.104838, 3.013283, 2.697896, 2.241960, 2.391608), tolerance=0.00001))
  expect_that(eed$Eed, is_equivalent_to(eed$coefs$Eed))
})

test_that("HED", {
  hed <<- shape(data, "hed")
  for(i in seq_along(hed))
      if(!names(hed)[i] %in% c("type","coefs","Hed"))
          expect_that(hed[[i]], equals(NULL))
  expect_that(hed$Hed, equals(setNames(c(6.659032, 6.456330, 6.265945, 5.610116, 4.662026, 4.973210),rownames(data$comm)), tolerance=0.00001))
  expect_that(hed$Hed, is_equivalent_to(hed$coefs$Hed))
})
#Euch. This doesn't work (for biologically valid reasons) and I'm suppressing tests until I can stop filling the screen with nonsense. It's tested again (with trait data) in the following sections...
test_that("dist FD", {
    data(laja)
    laja <<- comparative.comm(invert.tree, river.sites, warn=FALSE)
    #dist.fd <<- shape(laja, "dist.fd")
    #for(i in seq_along(dist.fd))
    #    if(!names(dist.fd)[i] %in% c("type","coefs"))
    #        expect_that(dist.fd[[i]], equals(NULL))
    #Great, we've asserted it doesn't work...
    #...but it does later.
})

test_that("Non-standard distance matrices",{
    sqrt <- shape(laja, "all", sqrt.phy=TRUE)
    expect_that(names(sqrt), equals(c("psv","psr","mpd","mntd","pd","pd.ivs","colless","gamma","taxon","eigen.sum","Eed","Hed","dist.fd","type","coefs")))
    t <- sqrt(cophenetic(laja$phy))
    ext.dist <- shape(laja, "all", ext.dist=as.dist(t))
    expect_that(identical(names(coef(sqrt)),names(coef(ext.dist))), is_false())
    expect_that(coef(sqrt)[,names(coef(ext.dist))], equals(coef(ext.dist)))
    t <- comparative.comm(invert.tree, river.sites, invert.traits)
    traitgram <- shape(t, traitgram=1)
    traitgram.group <- shape(t, "all", traitgram=c(0,0.5,1))
    expect_that(coef(traitgram), is_equivalent_to(traitgram.group[traitgram.group$traitgram==1.0,names(coef(traitgram))]))
})
